/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.Aggregation;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.Locale;
import org.rascalmpl.org.rascalmpl.java.util.Map;

public class AggregationUtil
extends Object {
    private static final Map<String, Aggregation> aggregationByName = new HashMap();
    private static final Map<Class<? extends Aggregation>, String> nameByAggregation;
    private static final String AGGREGATION_DEFAULT = "org.rascalmpl.org.rascalmpl.default";
    private static final String AGGREGATION_SUM = "org.rascalmpl.org.rascalmpl.sum";
    private static final String AGGREGATION_LAST_VALUE = "org.rascalmpl.org.rascalmpl.last_value";
    private static final String AGGREGATION_DROP = "org.rascalmpl.org.rascalmpl.drop";
    private static final String AGGREGATION_EXPLICIT_BUCKET_HISTOGRAM = "org.rascalmpl.org.rascalmpl.explicit_bucket_histogram";
    private static final String AGGREGATION_BASE2_EXPONENTIAL_HISTOGRAM = "org.rascalmpl.org.rascalmpl.base2_exponential_bucket_histogram";

    private AggregationUtil() {
    }

    public static Aggregation forName(String name) {
        Aggregation aggregation = (Aggregation)aggregationByName.get((Object)name.toLowerCase(Locale.ROOT));
        if (aggregation == null) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Unrecognized aggregation name ").append(name).toString());
        }
        return aggregation;
    }

    public static String aggregationName(Aggregation aggregation) {
        String name = (String)nameByAggregation.get((Object)aggregation.getClass());
        if (name == null) {
            throw new IllegalStateException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Unrecognized aggregation ").append(aggregation.getClass().getName()).toString());
        }
        return name;
    }

    static {
        aggregationByName.put((Object)"org.rascalmpl.org.rascalmpl.default", (Object)Aggregation.defaultAggregation());
        aggregationByName.put((Object)"org.rascalmpl.org.rascalmpl.sum", (Object)Aggregation.sum());
        aggregationByName.put((Object)"org.rascalmpl.org.rascalmpl.last_value", (Object)Aggregation.lastValue());
        aggregationByName.put((Object)"org.rascalmpl.org.rascalmpl.drop", (Object)Aggregation.drop());
        aggregationByName.put((Object)"org.rascalmpl.org.rascalmpl.explicit_bucket_histogram", (Object)Aggregation.explicitBucketHistogram());
        aggregationByName.put((Object)"org.rascalmpl.org.rascalmpl.base2_exponential_bucket_histogram", (Object)Aggregation.base2ExponentialBucketHistogram());
        nameByAggregation = new HashMap();
        nameByAggregation.put((Object)Aggregation.defaultAggregation().getClass(), (Object)"org.rascalmpl.org.rascalmpl.default");
        nameByAggregation.put((Object)Aggregation.sum().getClass(), (Object)"org.rascalmpl.org.rascalmpl.sum");
        nameByAggregation.put((Object)Aggregation.lastValue().getClass(), (Object)"org.rascalmpl.org.rascalmpl.last_value");
        nameByAggregation.put((Object)Aggregation.drop().getClass(), (Object)"org.rascalmpl.org.rascalmpl.drop");
        nameByAggregation.put((Object)Aggregation.explicitBucketHistogram().getClass(), (Object)"org.rascalmpl.org.rascalmpl.explicit_bucket_histogram");
        nameByAggregation.put((Object)Aggregation.base2ExponentialBucketHistogram().getClass(), (Object)"org.rascalmpl.org.rascalmpl.base2_exponential_bucket_histogram");
    }
}

