/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.export.MemoryMode;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.DoublePointData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.MetricData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.MutableDoublePointData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.state.Measurement;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.resources.Resource;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.atomic.AtomicReference;
import org.rascalmpl.org.rascalmpl.java.util.function.Supplier;
import org.rascalmpl.org.rascalmpl.javax.annotation.Nullable;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DoubleLastValueAggregator
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements Aggregator<DoublePointData, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;
    private final MemoryMode memoryMode;

    public DoubleLastValueAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, MemoryMode memoryMode) {
        this.reservoirSupplier = reservoirSupplier;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<DoublePointData, DoubleExemplarData> createHandle() {
        return new Handle((ExemplarReservoir)this.reservoirSupplier.get(), this.memoryMode);
    }

    @Override
    public DoublePointData diff(DoublePointData previous, DoublePointData current) {
        return current;
    }

    @Override
    public void diffInPlace(DoublePointData previousReusable, DoublePointData current) {
        ((MutableDoublePointData)previousReusable).set(current);
    }

    @Override
    public DoublePointData toPoint(Measurement measurement) {
        return ImmutableDoublePointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public void toPoint(Measurement measurement, DoublePointData reusablePoint) {
        ((MutableDoublePointData)reusablePoint).set(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public DoublePointData createReusablePoint() {
        return new MutableDoublePointData();
    }

    @Override
    public void copyPoint(DoublePointData point, DoublePointData toReusablePoint) {
        ((MutableDoublePointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<DoublePointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createDoubleGauge(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(points));
    }

    static final class Handle
    extends AggregatorHandle<DoublePointData, DoubleExemplarData> {
        @Nullable
        private static final Double DEFAULT_VALUE = null;
        private final AtomicReference<Double> current = new AtomicReference((org.rascalmpl.org.rascalmpl.java.lang.Object)DEFAULT_VALUE);
        @Nullable
        private final MutableDoublePointData reusablePoint;

        private Handle(ExemplarReservoir<DoubleExemplarData> reservoir, MemoryMode memoryMode) {
            super(reservoir);
            this.reusablePoint = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableDoublePointData() : null;
        }

        @Override
        protected DoublePointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars, boolean reset) {
            Double value;
            Double double_ = value = reset ? (Double)this.current.getAndSet((org.rascalmpl.org.rascalmpl.java.lang.Object)DEFAULT_VALUE) : (Double)this.current.get();
            if (this.reusablePoint != null) {
                this.reusablePoint.set(startEpochNanos, epochNanos, attributes, ((Double)Objects.requireNonNull((org.rascalmpl.org.rascalmpl.java.lang.Object)value)).doubleValue(), exemplars);
                return this.reusablePoint;
            }
            return ImmutableDoublePointData.create(startEpochNanos, epochNanos, attributes, ((Double)Objects.requireNonNull((org.rascalmpl.org.rascalmpl.java.lang.Object)value)).doubleValue(), exemplars);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.set((org.rascalmpl.org.rascalmpl.java.lang.Object)Double.valueOf((double)value));
        }
    }
}

