/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.export.MemoryMode;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.DoublePointData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.MetricData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.concurrent.AdderUtil;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.concurrent.DoubleAdder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.MutableDoublePointData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.state.Measurement;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.resources.Resource;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.function.Supplier;
import org.rascalmpl.org.rascalmpl.javax.annotation.Nullable;

public final class DoubleSumAggregator
extends AbstractSumAggregator<DoublePointData, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;
    private final MemoryMode memoryMode;

    public DoubleSumAggregator(InstrumentDescriptor instrumentDescriptor, Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, MemoryMode memoryMode) {
        super(instrumentDescriptor);
        this.reservoirSupplier = reservoirSupplier;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<DoublePointData, DoubleExemplarData> createHandle() {
        return new Handle((ExemplarReservoir)this.reservoirSupplier.get(), this.memoryMode);
    }

    @Override
    public DoublePointData diff(DoublePointData previousPoint, DoublePointData currentPoint) {
        return ImmutableDoublePointData.create(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousPoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public void diffInPlace(DoublePointData previousReusablePoint, DoublePointData currentPoint) {
        ((MutableDoublePointData)previousReusablePoint).set(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousReusablePoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public DoublePointData toPoint(Measurement measurement) {
        return ImmutableDoublePointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public void toPoint(Measurement measurement, DoublePointData reusablePoint) {
        ((MutableDoublePointData)reusablePoint).set(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public DoublePointData createReusablePoint() {
        return new MutableDoublePointData();
    }

    @Override
    public void copyPoint(DoublePointData point, DoublePointData toReusablePoint) {
        ((MutableDoublePointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<DoublePointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createDoubleSum(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableSumData.create(this.isMonotonic(), temporality, points));
    }

    static final class Handle
    extends AggregatorHandle<DoublePointData, DoubleExemplarData> {
        private final DoubleAdder current = AdderUtil.createDoubleAdder();
        @Nullable
        private final MutableDoublePointData reusablePoint;

        Handle(ExemplarReservoir<DoubleExemplarData> exemplarReservoir, MemoryMode memoryMode) {
            super(exemplarReservoir);
            this.reusablePoint = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableDoublePointData() : null;
        }

        @Override
        protected DoublePointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars, boolean reset) {
            double value;
            double d = value = reset ? this.current.sumThenReset() : this.current.sum();
            if (this.reusablePoint != null) {
                this.reusablePoint.set(startEpochNanos, epochNanos, attributes, value, exemplars);
                return this.reusablePoint;
            }
            return ImmutableDoublePointData.create(startEpochNanos, epochNanos, attributes, value, exemplars);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.add(value);
        }
    }
}

