/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data;

import org.rascalmpl.org.rascalmpl.com.google.auto.value.AutoValue;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal.PrimitiveLongList;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.HistogramPointData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.AutoValue_ImmutableHistogramPointData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.HistogramPointDataValidations;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Long;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class ImmutableHistogramPointData
extends Object
implements HistogramPointData {
    public static ImmutableHistogramPointData create(long startEpochNanos, long epochNanos, Attributes attributes, double sum, boolean hasMin, double min2, boolean hasMax, double max, List<Double> boundaries, List<Long> counts) {
        return ImmutableHistogramPointData.create(startEpochNanos, epochNanos, attributes, sum, hasMin, min2, hasMax, max, boundaries, counts, (List<DoubleExemplarData>)Collections.emptyList());
    }

    public static ImmutableHistogramPointData create(long startEpochNanos, long epochNanos, Attributes attributes, double sum, boolean hasMin, double min2, boolean hasMax, double max, List<Double> boundaries, List<Long> counts, List<DoubleExemplarData> exemplars) {
        if (counts.size() != boundaries.size() + 1) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.invalid counts: size should be ").append(boundaries.size() + 1).append((String)"org.rascalmpl.org.rascalmpl. instead of ").append(counts.size()).toString());
        }
        HistogramPointDataValidations.validateIsStrictlyIncreasing(boundaries);
        HistogramPointDataValidations.validateFiniteBoundaries(boundaries);
        long totalCount = 0L;
        for (long c : PrimitiveLongList.toArray(counts)) {
            totalCount += c;
        }
        return new AutoValue_ImmutableHistogramPointData(startEpochNanos, epochNanos, attributes, sum, totalCount, hasMin, min2, hasMax, max, (List<Double>)Collections.unmodifiableList((List)new ArrayList(boundaries)), (List<Long>)Collections.unmodifiableList((List)new ArrayList(counts)), exemplars);
    }

    ImmutableHistogramPointData() {
    }
}

