/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.DoublePointData;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Objects;

public class MutableDoublePointData
extends Object
implements DoublePointData {
    private long startEpochNanos;
    private long epochNanos;
    private Attributes attributes = Attributes.empty();
    private double value;
    private List<DoubleExemplarData> exemplars = Collections.emptyList();

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public List<DoubleExemplarData> getExemplars() {
        return this.exemplars;
    }

    public void set(DoublePointData point) {
        this.set(point.getStartEpochNanos(), point.getEpochNanos(), point.getAttributes(), point.getValue(), point.getExemplars());
    }

    public void set(long startEpochNanos, long epochNanos, Attributes attributes, double value) {
        this.set(startEpochNanos, epochNanos, attributes, value, (List<DoubleExemplarData>)Collections.emptyList());
    }

    public void set(long startEpochNanos, long epochNanos, Attributes attributes, double value, List<DoubleExemplarData> exemplars) {
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        this.attributes = attributes;
        this.value = value;
        this.exemplars = exemplars;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoublePointData)) {
            return false;
        }
        DoublePointData pointData = (DoublePointData)o;
        return this.startEpochNanos == pointData.getStartEpochNanos() && this.epochNanos == pointData.getEpochNanos() && Double.doubleToLongBits((double)this.value) == Double.doubleToLongBits((double)pointData.getValue()) && Objects.equals((Object)this.attributes, (Object)pointData.getAttributes()) && Objects.equals(this.exemplars, pointData.getExemplars());
    }

    public int hashCode() {
        int hashcode = 1;
        hashcode *= 1000003;
        hashcode ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        hashcode *= 1000003;
        hashcode ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        hashcode *= 1000003;
        hashcode ^= this.attributes.hashCode();
        hashcode *= 1000003;
        hashcode ^= (int)(Double.doubleToLongBits((double)this.value) >>> 32 ^ Double.doubleToLongBits((double)this.value));
        hashcode *= 1000003;
        return hashcode ^= this.exemplars.hashCode();
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.MutableDoublePointData{startEpochNanos=").append(this.startEpochNanos).append((String)"org.rascalmpl.org.rascalmpl., epochNanos=").append(this.epochNanos).append((String)"org.rascalmpl.org.rascalmpl., attributes=").append((Object)this.attributes).append((String)"org.rascalmpl.org.rascalmpl., value=").append(this.value).append((String)"org.rascalmpl.org.rascalmpl., exemplars=").append(this.exemplars).append('}').toString();
    }
}

