/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal.DynamicPrimitiveLongList;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.HistogramPointData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.data.HistogramPointDataValidations;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Long;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.List;

public final class MutableHistogramPointData
extends Object
implements HistogramPointData {
    private long startEpochNanos;
    private long epochNanos;
    private Attributes attributes = Attributes.empty();
    private double sum;
    private long count;
    private boolean hasMin;
    private double min;
    private boolean hasMax;
    private double max;
    private List<Double> boundaries = Collections.emptyList();
    private final DynamicPrimitiveLongList counts;
    private List<DoubleExemplarData> exemplars = Collections.emptyList();

    public MutableHistogramPointData(int buckets) {
        this.counts = DynamicPrimitiveLongList.ofSubArrayCapacity(buckets);
        this.counts.resizeAndClear(buckets);
    }

    public MutableHistogramPointData set(long startEpochNanos, long epochNanos, Attributes attributes, double sum, boolean hasMin, double min2, boolean hasMax, double max, List<Double> boundaries, long[] counts, List<DoubleExemplarData> exemplars) {
        int i;
        if (this.counts.size() != boundaries.size() + 1) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.invalid boundaries: size should be ").append(this.counts.size() - 1).append((String)"org.rascalmpl.org.rascalmpl. but was ").append(boundaries.size()).toString());
        }
        if (this.counts.size() != counts.length) {
            throw new IllegalArgumentException(new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.invalid counts: size should be ").append(this.counts.size()).append((String)"org.rascalmpl.org.rascalmpl. but was ").append(counts.length).toString());
        }
        HistogramPointDataValidations.validateIsStrictlyIncreasing(boundaries);
        HistogramPointDataValidations.validateFiniteBoundaries(boundaries);
        long totalCount = 0L;
        for (i = 0; i < counts.length; ++i) {
            totalCount += counts[i];
        }
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        this.attributes = attributes;
        this.sum = sum;
        this.count = totalCount;
        this.hasMin = hasMin;
        this.min = min2;
        this.hasMax = hasMax;
        this.max = max;
        this.boundaries = boundaries;
        for (i = 0; i < counts.length; ++i) {
            this.counts.setLong(i, counts[i]);
        }
        this.exemplars = exemplars;
        return this;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public boolean hasMin() {
        return this.hasMin;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public boolean hasMax() {
        return this.hasMax;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public List<Double> getBoundaries() {
        return this.boundaries;
    }

    @Override
    public List<Long> getCounts() {
        return this.counts;
    }

    @Override
    public List<DoubleExemplarData> getExemplars() {
        return this.exemplars;
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.MutableHistogramPointData{startEpochNanos=").append(this.startEpochNanos).append((String)"org.rascalmpl.org.rascalmpl., epochNanos=").append(this.epochNanos).append((String)"org.rascalmpl.org.rascalmpl., attributes=").append((Object)this.attributes).append((String)"org.rascalmpl.org.rascalmpl., sum=").append(this.sum).append((String)"org.rascalmpl.org.rascalmpl., count=").append(this.count).append((String)"org.rascalmpl.org.rascalmpl., hasMin=").append(this.hasMin).append((String)"org.rascalmpl.org.rascalmpl., min=").append(this.min).append((String)"org.rascalmpl.org.rascalmpl., hasMax=").append(this.hasMax).append((String)"org.rascalmpl.org.rascalmpl., max=").append(this.max).append((String)"org.rascalmpl.org.rascalmpl., boundaries=").append(this.boundaries).append((String)"org.rascalmpl.org.rascalmpl., counts=").append((Object)this.counts).append((String)"org.rascalmpl.org.rascalmpl., exemplars=").append(this.exemplars).append((String)"org.rascalmpl.org.rascalmpl.}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HistogramPointData) {
            HistogramPointData that = (HistogramPointData)o;
            return this.startEpochNanos == that.getStartEpochNanos() && this.epochNanos == that.getEpochNanos() && this.attributes.equals(that.getAttributes()) && Double.doubleToLongBits((double)this.sum) == Double.doubleToLongBits((double)that.getSum()) && this.count == that.getCount() && this.hasMin == that.hasMin() && Double.doubleToLongBits((double)this.min) == Double.doubleToLongBits((double)that.getMin()) && this.hasMax == that.hasMax() && Double.doubleToLongBits((double)this.max) == Double.doubleToLongBits((double)that.getMax()) && this.boundaries.equals(that.getBoundaries()) && this.counts.equals((Object)that.getCounts()) && this.exemplars.equals(that.getExemplars());
        }
        return false;
    }

    public int hashCode() {
        int hashcode = 1;
        hashcode *= 1000003;
        hashcode ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        hashcode *= 1000003;
        hashcode ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        hashcode *= 1000003;
        hashcode ^= this.attributes.hashCode();
        hashcode *= 1000003;
        hashcode ^= (int)(Double.doubleToLongBits((double)this.sum) >>> 32 ^ Double.doubleToLongBits((double)this.sum));
        hashcode *= 1000003;
        hashcode ^= (int)(this.count >>> 32 ^ this.count);
        hashcode *= 1000003;
        hashcode ^= this.hasMin ? 1231 : 1237;
        hashcode *= 1000003;
        hashcode ^= (int)(Double.doubleToLongBits((double)this.min) >>> 32 ^ Double.doubleToLongBits((double)this.min));
        hashcode *= 1000003;
        hashcode ^= this.hasMax ? 1231 : 1237;
        hashcode *= 1000003;
        hashcode ^= (int)(Double.doubleToLongBits((double)this.max) >>> 32 ^ Double.doubleToLongBits((double)this.max));
        hashcode *= 1000003;
        hashcode ^= this.boundaries.hashCode();
        hashcode *= 1000003;
        hashcode ^= this.counts.hashCode();
        hashcode *= 1000003;
        return hashcode ^= this.exemplars.hashCode();
    }
}

