/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.debug;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.StackTraceElement;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;

final class StackTraceSourceInfo
extends Object
implements SourceInfo {
    private final StackTraceElement[] stackTraceElements;

    StackTraceSourceInfo(StackTraceElement[] stackTraceElements) {
        this.stackTraceElements = stackTraceElements;
    }

    @Override
    public String shortDebugString() {
        if (this.stackTraceElements.length > 0) {
            for (StackTraceElement e : this.stackTraceElements) {
                if (!StackTraceSourceInfo.isInterestingStackTrace(e)) continue;
                return String.format((String)"org.rascalmpl.org.rascalmpl.%s:%d", (Object[])new Object[]{e.getFileName(), Integer.valueOf((int)e.getLineNumber())});
            }
        }
        return "org.rascalmpl.org.rascalmpl.unknown source";
    }

    @Override
    public String multiLineDebugString() {
        if (this.stackTraceElements.length > 0) {
            StringBuilder result = new StringBuilder();
            for (StackTraceElement e : this.stackTraceElements) {
                if (!StackTraceSourceInfo.isInterestingStackTrace(e)) continue;
                result.append((String)"org.rascalmpl.org.rascalmpl.\tat ").append((Object)e).append((String)"org.rascalmpl.org.rascalmpl.\n");
            }
            return result.toString();
        }
        return "org.rascalmpl.org.rascalmpl.\tat unknown source";
    }

    private static boolean isInterestingStackTrace(StackTraceElement e) {
        return !e.getClassName().startsWith((String)"org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics") && !e.getClassName().startsWith((String)"org.rascalmpl.org.rascalmpl.java.lang");
    }
}

