/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.descriptor;

import org.rascalmpl.org.rascalmpl.com.google.auto.value.AutoValue;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.InstrumentType;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.InstrumentValueType;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.View;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.AggregationUtil;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.debug.SourceInfo;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.descriptor.AutoValue_MetricDescriptor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.Locale;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.atomic.AtomicReference;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class MetricDescriptor
extends Object {
    private final AtomicReference<SourceInfo> viewSourceInfo = new AtomicReference();
    private int hashcode;

    public static MetricDescriptor create(String name, String description, String unit) {
        return MetricDescriptor.create(View.builder().build(), SourceInfo.fromCurrentStack(), InstrumentDescriptor.create(name, description, unit, InstrumentType.OBSERVABLE_GAUGE, InstrumentValueType.DOUBLE, Advice.empty()));
    }

    public static MetricDescriptor create(View view, SourceInfo viewSourceInfo, InstrumentDescriptor instrument) {
        String name = view.getName() == null ? instrument.getName() : view.getName();
        String description = view.getDescription() == null ? instrument.getDescription() : view.getDescription();
        AutoValue_MetricDescriptor metricDescriptor = new AutoValue_MetricDescriptor(name, description, view, instrument);
        metricDescriptor.viewSourceInfo.set((Object)viewSourceInfo);
        return metricDescriptor;
    }

    MetricDescriptor() {
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract View getView();

    public final SourceInfo getViewSourceInfo() {
        SourceInfo sourceInfo = (SourceInfo)this.viewSourceInfo.get();
        return sourceInfo == null ? SourceInfo.noSourceInfo() : sourceInfo;
    }

    public abstract InstrumentDescriptor getSourceInstrument();

    public String getAggregationName() {
        return AggregationUtil.aggregationName(this.getView().getAggregation());
    }

    public final int hashCode() {
        int result = this.hashcode;
        if (result == 0) {
            result = 1;
            result *= 1000003;
            result ^= this.getName().toLowerCase(Locale.ROOT).hashCode();
            result *= 1000003;
            result ^= this.getDescription().hashCode();
            result *= 1000003;
            result ^= this.getView().hashCode();
            result *= 1000003;
            this.hashcode = result ^= this.getSourceInstrument().hashCode();
        }
        return result;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MetricDescriptor) {
            MetricDescriptor that = (MetricDescriptor)o;
            return this.getName().equalsIgnoreCase(that.getName()) && this.getDescription().equals((Object)that.getDescription()) && this.getView().equals(that.getView()) && this.getSourceInstrument().equals(that.getSourceInstrument());
        }
        return false;
    }
}

