/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.Clock;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.FilteredExemplarReservoir;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.HistogramExemplarReservoir;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.LongToDoubleExemplarReservoir;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.NoopExemplarReservoir;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.RandomFixedSizeExemplarReservoir;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Random;
import org.rascalmpl.org.rascalmpl.java.util.function.Supplier;

public interface ExemplarReservoir<T extends ExemplarData> {
    public static <T extends ExemplarData> ExemplarReservoir<T> longToDouble(ExemplarReservoir<T> delegate) {
        return new LongToDoubleExemplarReservoir<T>(delegate);
    }

    public static <T extends ExemplarData> ExemplarReservoir<T> filtered(ExemplarFilter filter, ExemplarReservoir<T> original) {
        return new FilteredExemplarReservoir<T>(filter, original);
    }

    public static ExemplarReservoir<DoubleExemplarData> doubleNoSamples() {
        return NoopExemplarReservoir.DOUBLE_INSTANCE;
    }

    public static ExemplarReservoir<LongExemplarData> longNoSamples() {
        return NoopExemplarReservoir.LONG_INSTANCE;
    }

    public static ExemplarReservoir<DoubleExemplarData> doubleFixedSizeReservoir(Clock clock, int size, Supplier<Random> randomSupplier) {
        return RandomFixedSizeExemplarReservoir.createDouble(clock, size, randomSupplier);
    }

    public static ExemplarReservoir<LongExemplarData> longFixedSizeReservoir(Clock clock, int size, Supplier<Random> randomSupplier) {
        return RandomFixedSizeExemplarReservoir.createLong(clock, size, randomSupplier);
    }

    public static ExemplarReservoir<DoubleExemplarData> histogramBucketReservoir(Clock clock, List<Double> boundaries) {
        return new HistogramExemplarReservoir(clock, boundaries);
    }

    public void offerDoubleMeasurement(double var1, Attributes var3, Context var4);

    public void offerLongMeasurement(long var1, Attributes var3, Context var4);

    public List<T> collectAndReset(Attributes var1);
}

