/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.util.List;

class FilteredExemplarReservoir<T extends ExemplarData>
extends Object
implements ExemplarReservoir<T> {
    private final ExemplarFilter filter;
    private final ExemplarReservoir<T> reservoir;

    FilteredExemplarReservoir(ExemplarFilter filter, ExemplarReservoir<T> reservoir) {
        this.filter = filter;
        this.reservoir = reservoir;
    }

    @Override
    public void offerDoubleMeasurement(double value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerDoubleMeasurement(value, attributes, context);
        }
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context) {
        if (this.filter.shouldSampleMeasurement(value, attributes, context)) {
            this.reservoir.offerLongMeasurement(value, attributes, context);
        }
    }

    @Override
    public List<T> collectAndReset(Attributes pointAttributes) {
        return this.reservoir.collectAndReset(pointAttributes);
    }
}

