/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.Clock;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCell;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ReservoirCellSelector;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.function.BiFunction;

abstract class FixedSizeExemplarReservoir<T extends ExemplarData>
extends Object
implements ExemplarReservoir<T> {
    private final ReservoirCell[] storage;
    private final ReservoirCellSelector reservoirCellSelector;
    private final BiFunction<ReservoirCell, Attributes, T> mapAndResetCell;
    private volatile boolean hasMeasurements = false;

    FixedSizeExemplarReservoir(Clock clock, int size, ReservoirCellSelector reservoirCellSelector, BiFunction<ReservoirCell, Attributes, T> mapAndResetCell) {
        this.storage = new ReservoirCell[size];
        for (int i = 0; i < size; ++i) {
            this.storage[i] = new ReservoirCell(clock);
        }
        this.reservoirCellSelector = reservoirCellSelector;
        this.mapAndResetCell = mapAndResetCell;
    }

    @Override
    public void offerLongMeasurement(long value, Attributes attributes, Context context) {
        int bucket = this.reservoirCellSelector.reservoirCellIndexFor(this.storage, value, attributes, context);
        if (bucket != -1) {
            this.storage[bucket].recordLongMeasurement(value, attributes, context);
            this.hasMeasurements = true;
        }
    }

    @Override
    public void offerDoubleMeasurement(double value, Attributes attributes, Context context) {
        int bucket = this.reservoirCellSelector.reservoirCellIndexFor(this.storage, value, attributes, context);
        if (bucket != -1) {
            this.storage[bucket].recordDoubleMeasurement(value, attributes, context);
            this.hasMeasurements = true;
        }
    }

    @Override
    public List<T> collectAndReset(Attributes pointAttributes) {
        if (!this.hasMeasurements) {
            return Collections.emptyList();
        }
        ArrayList results = new ArrayList();
        for (ReservoirCell reservoirCell : this.storage) {
            ExemplarData result = (ExemplarData)this.mapAndResetCell.apply((Object)reservoirCell, (Object)pointAttributes);
            if (result == null) continue;
            results.add((Object)result);
        }
        this.reservoirCellSelector.reset();
        this.hasMeasurements = false;
        return Collections.unmodifiableList((List)results);
    }
}

