/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.state;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.export.MemoryMode;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal.ThrottlingLogger;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.MetricData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.PointData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.state.SynchronousMetricStorage;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.resources.Resource;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.Queue;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ConcurrentHashMap;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ConcurrentLinkedQueue;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.atomic.AtomicInteger;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;

public final class DefaultSynchronousMetricStorage<T extends PointData, U extends ExemplarData>
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements SynchronousMetricStorage {
    private static final Logger internalLogger = Logger.getLogger((String)DefaultSynchronousMetricStorage.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final RegisteredReader registeredReader;
    private final MetricDescriptor metricDescriptor;
    private final AggregationTemporality aggregationTemporality;
    private final Aggregator<T, U> aggregator;
    private volatile AggregatorHolder<T, U> aggregatorHolder = new AggregatorHolder();
    private final AttributesProcessor attributesProcessor;
    private final MemoryMode memoryMode;
    private final ArrayList<T> reusableResultList = new ArrayList();
    private volatile ConcurrentHashMap<Attributes, AggregatorHandle<T, U>> previousCollectionAggregatorHandles = new ConcurrentHashMap();
    private final int maxCardinality;
    private final ConcurrentLinkedQueue<AggregatorHandle<T, U>> aggregatorHandlePool = new ConcurrentLinkedQueue();

    DefaultSynchronousMetricStorage(RegisteredReader registeredReader, MetricDescriptor metricDescriptor, Aggregator<T, U> aggregator, AttributesProcessor attributesProcessor, int maxCardinality) {
        this.registeredReader = registeredReader;
        this.metricDescriptor = metricDescriptor;
        this.aggregationTemporality = registeredReader.getReader().getAggregationTemporality(metricDescriptor.getSourceInstrument().getType());
        this.aggregator = aggregator;
        this.attributesProcessor = attributesProcessor;
        this.maxCardinality = maxCardinality - 1;
        this.memoryMode = registeredReader.getReader().getMemoryMode();
    }

    Queue<AggregatorHandle<T, U>> getAggregatorHandlePool() {
        return this.aggregatorHandlePool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordLong(long value, Attributes attributes, Context context) {
        AggregatorHolder<T, U> aggregatorHolder = this.getHolderForRecord();
        try {
            AggregatorHandle<T, U> handle = this.getAggregatorHandle(((AggregatorHolder)aggregatorHolder).aggregatorHandles, attributes, context);
            handle.recordLong(value, attributes, context);
        }
        finally {
            this.releaseHolderForRecord(aggregatorHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordDouble(double value, Attributes attributes, Context context) {
        if (Double.isNaN((double)value)) {
            this.logger.log(Level.FINE, new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Instrument ").append(this.metricDescriptor.getSourceInstrument().getName()).append((String)"org.rascalmpl.org.rascalmpl. has recorded measurement Not-a-Number (NaN) value with attributes ").append((org.rascalmpl.org.rascalmpl.java.lang.Object)attributes).append((String)"org.rascalmpl.org.rascalmpl.. Dropping measurement.").toString());
            return;
        }
        AggregatorHolder<T, U> aggregatorHolder = this.getHolderForRecord();
        try {
            AggregatorHandle<T, U> handle = this.getAggregatorHandle(((AggregatorHolder)aggregatorHolder).aggregatorHandles, attributes, context);
            handle.recordDouble(value, attributes, context);
        }
        finally {
            this.releaseHolderForRecord(aggregatorHolder);
        }
    }

    private AggregatorHolder<T, U> getHolderForRecord() {
        AggregatorHolder<T, U> aggregatorHolder;
        int recordsInProgress;
        while ((recordsInProgress = ((AggregatorHolder)(aggregatorHolder = this.aggregatorHolder)).activeRecordingThreads.addAndGet(2)) % 2 != 0) {
            ((AggregatorHolder)aggregatorHolder).activeRecordingThreads.addAndGet(-2);
        }
        return aggregatorHolder;
    }

    private void releaseHolderForRecord(AggregatorHolder<T, U> aggregatorHolder) {
        ((AggregatorHolder)aggregatorHolder).activeRecordingThreads.addAndGet(-2);
    }

    private AggregatorHandle<T, U> getAggregatorHandle(ConcurrentHashMap<Attributes, AggregatorHandle<T, U>> aggregatorHandles, Attributes attributes, Context context) {
        AggregatorHandle newHandle;
        Objects.requireNonNull((org.rascalmpl.org.rascalmpl.java.lang.Object)attributes, (String)"org.rascalmpl.org.rascalmpl.attributes");
        attributes = this.attributesProcessor.process(attributes, context);
        AggregatorHandle handle = (AggregatorHandle)aggregatorHandles.get((org.rascalmpl.org.rascalmpl.java.lang.Object)attributes);
        if (handle != null) {
            return handle;
        }
        if (aggregatorHandles.size() >= this.maxCardinality) {
            this.logger.log(Level.WARNING, new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Instrument ").append(this.metricDescriptor.getSourceInstrument().getName()).append((String)"org.rascalmpl.org.rascalmpl. has exceeded the maximum allowed cardinality (").append(this.maxCardinality).append((String)"org.rascalmpl.org.rascalmpl.).").toString());
            attributes = MetricStorage.CARDINALITY_OVERFLOW;
            handle = (AggregatorHandle)aggregatorHandles.get((org.rascalmpl.org.rascalmpl.java.lang.Object)attributes);
            if (handle != null) {
                return handle;
            }
        }
        if ((newHandle = (AggregatorHandle)this.aggregatorHandlePool.poll()) == null) {
            newHandle = this.aggregator.createHandle();
        }
        return (handle = (AggregatorHandle)aggregatorHandles.putIfAbsent((org.rascalmpl.org.rascalmpl.java.lang.Object)attributes, newHandle)) != null ? handle : newHandle;
    }

    /*
     * Exception decompiling
     */
    @Override
    public MetricData collect(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long startEpochNanos, long epochNanos) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/org/rascalmpl/java/lang/Object;Lorg/rascalmpl/org/rascalmpl/java/lang/Object;)V
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    private /* synthetic */ void lambda$collect$1(long start, long epochNanos, boolean reset, List points, Attributes attributes, AggregatorHandle handle) {
        if (!handle.hasRecordedValues()) {
            return;
        }
        Object point = handle.aggregateThenMaybeReset(start, epochNanos, attributes, reset);
        if (reset && this.memoryMode == MemoryMode.IMMUTABLE_DATA) {
            this.aggregatorHandlePool.offer((org.rascalmpl.org.rascalmpl.java.lang.Object)handle);
        }
        if (point != null) {
            points.add(point);
        }
    }

    private static /* synthetic */ void lambda$collect$0(ConcurrentHashMap aggregatorHandles, Attributes attribute, AggregatorHandle handle) {
        if (!handle.hasRecordedValues()) {
            aggregatorHandles.remove((org.rascalmpl.org.rascalmpl.java.lang.Object)attribute);
        }
    }

    private static class AggregatorHolder<T extends PointData, U extends ExemplarData>
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        private final ConcurrentHashMap<Attributes, AggregatorHandle<T, U>> aggregatorHandles;
        private final AtomicInteger activeRecordingThreads = new AtomicInteger(0);

        private AggregatorHolder() {
            this.aggregatorHandles = new ConcurrentHashMap();
        }

        private AggregatorHolder(ConcurrentHashMap<Attributes, AggregatorHandle<T, U>> aggregatorHandles) {
            this.aggregatorHandles = aggregatorHandles;
        }
    }
}

