/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.view;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.export.MemoryMode;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal.ThrottlingLogger;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.Aggregation;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.data.PointData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.view.DropAggregation;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.view.ExplicitBucketHistogramAggregation;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.view.LastValueAggregation;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.metrics.internal.view.SumAggregation;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;

public final class DefaultAggregation
extends Object
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new DefaultAggregation();
    private static final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger((String)DefaultAggregation.class.getName()));

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private DefaultAggregation() {
    }

    private static Aggregation resolve(InstrumentDescriptor instrument, boolean withAdvice) {
        switch (instrument.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: 
            case OBSERVABLE_COUNTER: 
            case OBSERVABLE_UP_DOWN_COUNTER: {
                return SumAggregation.getInstance();
            }
            case HISTOGRAM: {
                if (withAdvice && instrument.getAdvice().getExplicitBucketBoundaries() != null) {
                    return ExplicitBucketHistogramAggregation.create(instrument.getAdvice().getExplicitBucketBoundaries());
                }
                return ExplicitBucketHistogramAggregation.getDefault();
            }
            case OBSERVABLE_GAUGE: 
            case GAUGE: {
                return LastValueAggregation.getInstance();
            }
        }
        logger.log(Level.WARNING, new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.Unable to find default aggregation for instrument: ").append((Object)instrument).toString());
        return DropAggregation.getInstance();
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter, MemoryMode memoryMode) {
        return ((AggregatorFactory)((java.lang.Object)DefaultAggregation.resolve(instrumentDescriptor, true))).createAggregator(instrumentDescriptor, exemplarFilter, memoryMode);
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        return ((AggregatorFactory)((java.lang.Object)DefaultAggregation.resolve(instrumentDescriptor, false))).isCompatibleWithInstrument(instrumentDescriptor);
    }

    public String toString() {
        return "org.rascalmpl.org.rascalmpl.DefaultAggregation";
    }
}

