/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.AttributeKey;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.Span;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.SpanContext;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.SpanKind;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.StatusCode;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.Clock;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal.AttributeUtil;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal.AttributesMap;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal.InstrumentationScopeUtil;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.resources.Resource;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.AnchoredClock;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.ReadWriteSpan;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.SpanLimits;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.SpanProcessor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.SpanWrapper;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.data.EventData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.data.LinkData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.data.SpanData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.data.StatusData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.internal.data.ExceptionEventData;
import org.rascalmpl.org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.javax.annotation.Nullable;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SdkSpan
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements ReadWriteSpan {
    private static final Logger logger = Logger.getLogger((String)SdkSpan.class.getName());
    private final SpanLimits spanLimits;
    private final SpanContext context;
    private final SpanContext parentSpanContext;
    private final SpanProcessor spanProcessor;
    private final SpanKind kind;
    private final AnchoredClock clock;
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final long startEpochNanos;
    private final org.rascalmpl.org.rascalmpl.java.lang.Object lock = new org.rascalmpl.org.rascalmpl.java.lang.Object();
    private String name;
    @Nullable
    private AttributesMap attributes;
    @Nullable
    private List<EventData> events;
    private int totalRecordedEvents = 0;
    @Nullable
    List<LinkData> links;
    private int totalRecordedLinks;
    private StatusData status = StatusData.unset();
    private long endEpochNanos;
    private boolean hasEnded;

    private SdkSpan(SpanContext context, String name, InstrumentationScopeInfo instrumentationScopeInfo, SpanKind kind, SpanContext parentSpanContext, SpanLimits spanLimits, SpanProcessor spanProcessor, AnchoredClock clock, Resource resource, @Nullable AttributesMap attributes, @Nullable List<LinkData> links, int totalRecordedLinks, long startEpochNanos) {
        this.context = context;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.parentSpanContext = parentSpanContext;
        this.links = links;
        this.totalRecordedLinks = totalRecordedLinks;
        this.name = name;
        this.kind = kind;
        this.spanProcessor = spanProcessor;
        this.resource = resource;
        this.hasEnded = false;
        this.clock = clock;
        this.startEpochNanos = startEpochNanos;
        this.attributes = attributes;
        this.spanLimits = spanLimits;
    }

    static SdkSpan startSpan(SpanContext context, String name, InstrumentationScopeInfo instrumentationScopeInfo, SpanKind kind, Span parentSpan, Context parentContext, SpanLimits spanLimits, SpanProcessor spanProcessor, Clock tracerClock, Resource resource, @Nullable AttributesMap attributes, @Nullable List<LinkData> links, int totalRecordedLinks, long userStartEpochNanos) {
        boolean createdAnchoredClock;
        AnchoredClock clock;
        if (parentSpan instanceof SdkSpan) {
            SdkSpan parentRecordEventsSpan = (SdkSpan)parentSpan;
            clock = parentRecordEventsSpan.clock;
            createdAnchoredClock = false;
        } else {
            clock = AnchoredClock.create(tracerClock);
            createdAnchoredClock = true;
        }
        long startEpochNanos = userStartEpochNanos != 0L ? userStartEpochNanos : (createdAnchoredClock ? clock.startTime() : clock.now());
        SdkSpan span = new SdkSpan(context, name, instrumentationScopeInfo, kind, parentSpan.getSpanContext(), spanLimits, spanProcessor, clock, resource, attributes, links, totalRecordedLinks, startEpochNanos);
        if (spanProcessor.isStartRequired()) {
            spanProcessor.onStart(parentContext, span);
        }
        return span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpanData toSpanData() {
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            return SpanWrapper.create(this, this.getImmutableLinks(), this.getImmutableTimedEvents(), this.getImmutableAttributes(), this.attributes == null ? 0 : this.attributes.getTotalAddedValues(), this.totalRecordedEvents, this.totalRecordedLinks, this.status, this.name, this.endEpochNanos, this.hasEnded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T extends org.rascalmpl.org.rascalmpl.java.lang.Object> T getAttribute(AttributeKey<T> key) {
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            return this.attributes == null ? null : (T)this.attributes.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attributes getAttributes() {
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            return this.attributes == null ? Attributes.empty() : this.attributes.immutableCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEnded() {
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            return this.hasEnded;
        }
    }

    @Override
    public SpanContext getSpanContext() {
        return this.context;
    }

    @Override
    public SpanContext getParentSpanContext() {
        return this.parentSpanContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            return this.name;
        }
    }

    @Override
    @Deprecated
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return InstrumentationScopeUtil.toInstrumentationLibraryInfo(this.getInstrumentationScopeInfo());
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencyNanos() {
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            return (this.hasEnded ? this.endEpochNanos : this.clock.now()) - this.startEpochNanos;
        }
    }

    AnchoredClock getClock() {
        return this.clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends org.rascalmpl.org.rascalmpl.java.lang.Object> ReadWriteSpan setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, (String)"org.rascalmpl.org.rascalmpl.Calling setAttribute() on an ended Span.");
                return this;
            }
            if (this.attributes == null) {
                this.attributes = AttributesMap.create(this.spanLimits.getMaxNumberOfAttributes(), this.spanLimits.getMaxAttributeValueLength());
            }
            this.attributes.put(key, value);
        }
        return this;
    }

    @Override
    public ReadWriteSpan addEvent(String name) {
        if (name == null) {
            return this;
        }
        this.addTimedEvent(EventData.create(this.clock.now(), name, Attributes.empty(), 0));
        return this;
    }

    @Override
    public ReadWriteSpan addEvent(String name, long timestamp, TimeUnit unit) {
        if (name == null || unit == null) {
            return this;
        }
        this.addTimedEvent(EventData.create(unit.toNanos(timestamp), name, Attributes.empty(), 0));
        return this;
    }

    @Override
    public ReadWriteSpan addEvent(String name, Attributes attributes) {
        if (name == null) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        int totalAttributeCount = attributes.size();
        this.addTimedEvent(EventData.create(this.clock.now(), name, AttributeUtil.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerEvent(), this.spanLimits.getMaxAttributeValueLength()), totalAttributeCount));
        return this;
    }

    @Override
    public ReadWriteSpan addEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
        if (name == null || unit == null) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        int totalAttributeCount = attributes.size();
        this.addTimedEvent(EventData.create(unit.toNanos(timestamp), name, AttributeUtil.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerEvent(), this.spanLimits.getMaxAttributeValueLength()), totalAttributeCount));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimedEvent(EventData timedEvent) {
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, (String)"org.rascalmpl.org.rascalmpl.Calling addEvent() on an ended Span.");
                return;
            }
            if (this.events == null) {
                this.events = new ArrayList();
            }
            if (this.events.size() < this.spanLimits.getMaxNumberOfEvents()) {
                this.events.add((org.rascalmpl.org.rascalmpl.java.lang.Object)timedEvent);
            }
            ++this.totalRecordedEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadWriteSpan setStatus(StatusCode statusCode, @Nullable String description) {
        if (statusCode == null) {
            return this;
        }
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, (String)"org.rascalmpl.org.rascalmpl.Calling setStatus() on an ended Span.");
                return this;
            }
            if (this.status.getStatusCode() == StatusCode.OK) {
                logger.log(Level.FINE, (String)"org.rascalmpl.org.rascalmpl.Calling setStatus() on a Span that is already set to OK.");
                return this;
            }
            this.status = StatusData.create(statusCode, description);
        }
        return this;
    }

    @Override
    public ReadWriteSpan recordException(Throwable exception) {
        this.recordException(exception, Attributes.empty());
        return this;
    }

    @Override
    public ReadWriteSpan recordException(Throwable exception, Attributes additionalAttributes) {
        if (exception == null) {
            return this;
        }
        if (additionalAttributes == null) {
            additionalAttributes = Attributes.empty();
        }
        this.addTimedEvent(ExceptionEventData.create(this.spanLimits, this.clock.now(), exception, additionalAttributes));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadWriteSpan updateName(String name) {
        if (name == null) {
            return this;
        }
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, (String)"org.rascalmpl.org.rascalmpl.Calling updateName() on an ended Span.");
                return this;
            }
            this.name = name;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span addLink(SpanContext spanContext, Attributes attributes) {
        if (spanContext == null || !spanContext.isValid()) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        LinkData link = LinkData.create(spanContext, AttributeUtil.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerLink(), this.spanLimits.getMaxAttributeValueLength()));
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, (String)"org.rascalmpl.org.rascalmpl.Calling addLink() on an ended Span.");
                return this;
            }
            if (this.links == null) {
                this.links = new ArrayList();
            }
            if (this.links.size() < this.spanLimits.getMaxNumberOfLinks()) {
                this.links.add((org.rascalmpl.org.rascalmpl.java.lang.Object)link);
            }
            ++this.totalRecordedLinks;
        }
        return this;
    }

    @Override
    public void end() {
        this.endInternal(this.clock.now());
    }

    @Override
    public void end(long timestamp, TimeUnit unit) {
        if (unit == null) {
            unit = TimeUnit.NANOSECONDS;
        }
        this.endInternal(timestamp == 0L ? this.clock.now() : unit.toNanos(timestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endInternal(long endEpochNanos) {
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, (String)"org.rascalmpl.org.rascalmpl.Calling end() on an ended Span.");
                return;
            }
            this.endEpochNanos = endEpochNanos;
            this.hasEnded = true;
        }
        if (this.spanProcessor.isEndRequired()) {
            this.spanProcessor.onEnd(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRecording() {
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            return !this.hasEnded;
        }
    }

    Resource getResource() {
        return this.resource;
    }

    @Override
    public SpanKind getKind() {
        return this.kind;
    }

    long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    private List<EventData> getImmutableTimedEvents() {
        if (this.events == null) {
            return Collections.emptyList();
        }
        if (this.hasEnded) {
            return Collections.unmodifiableList(this.events);
        }
        return Collections.unmodifiableList((List)new ArrayList(this.events));
    }

    private Attributes getImmutableAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return Attributes.empty();
        }
        if (this.hasEnded) {
            return this.attributes;
        }
        return this.attributes.immutableCopy();
    }

    private List<LinkData> getImmutableLinks() {
        if (this.links == null || this.links.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.links);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long totalRecordedLinks;
        long endEpochNanos;
        long totalRecordedEvents;
        String status;
        String attributes;
        String name;
        org.rascalmpl.org.rascalmpl.java.lang.Object object = this.lock;
        synchronized (object) {
            name = this.name;
            attributes = String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)this.attributes);
            status = String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)this.status);
            totalRecordedEvents = this.totalRecordedEvents;
            endEpochNanos = this.endEpochNanos;
            totalRecordedLinks = this.totalRecordedLinks;
        }
        return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.SdkSpan{traceId=").append(this.context.getTraceId()).append((String)"org.rascalmpl.org.rascalmpl., spanId=").append(this.context.getSpanId()).append((String)"org.rascalmpl.org.rascalmpl., parentSpanContext=").append((org.rascalmpl.org.rascalmpl.java.lang.Object)this.parentSpanContext).append((String)"org.rascalmpl.org.rascalmpl., name=").append(name).append((String)"org.rascalmpl.org.rascalmpl., kind=").append((org.rascalmpl.org.rascalmpl.java.lang.Object)this.kind).append((String)"org.rascalmpl.org.rascalmpl., attributes=").append(attributes).append((String)"org.rascalmpl.org.rascalmpl., status=").append(status).append((String)"org.rascalmpl.org.rascalmpl., totalRecordedEvents=").append(totalRecordedEvents).append((String)"org.rascalmpl.org.rascalmpl., totalRecordedLinks=").append(totalRecordedLinks).append((String)"org.rascalmpl.org.rascalmpl., startEpochNanos=").append(this.startEpochNanos).append((String)"org.rascalmpl.org.rascalmpl., endEpochNanos=").append(endEpochNanos).append((String)"org.rascalmpl.org.rascalmpl.}").toString();
    }
}

