/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.SpanBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.Tracer;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.TracerProvider;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.SdkSpanBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.TracerSharedState;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.internal.TracerConfig;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;

final class SdkTracer
extends Object
implements Tracer {
    static final String FALLBACK_SPAN_NAME = "org.rascalmpl.org.rascalmpl.<unspecified span name>";
    private static final Tracer NOOP_TRACER = TracerProvider.noop().get((String)"org.rascalmpl.org.rascalmpl.noop");
    private final TracerSharedState sharedState;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final TracerConfig tracerConfig;

    SdkTracer(TracerSharedState sharedState, InstrumentationScopeInfo instrumentationScopeInfo, TracerConfig tracerConfig) {
        this.sharedState = sharedState;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.tracerConfig = tracerConfig;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        if (!this.tracerConfig.isEnabled()) {
            return NOOP_TRACER.spanBuilder((String)spanName);
        }
        if (spanName == null || spanName.trim().isEmpty()) {
            spanName = "org.rascalmpl.org.rascalmpl.<unspecified span name>";
        }
        if (this.sharedState.hasBeenShutdown()) {
            Tracer tracer = TracerProvider.noop().get(this.instrumentationScopeInfo.getName());
            return tracer.spanBuilder((String)spanName);
        }
        return new SdkSpanBuilder((String)spanName, this.instrumentationScopeInfo, this.sharedState, this.sharedState.getSpanLimits());
    }

    InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }
}

