/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.context.Context;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.MultiSpanProcessor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.NoopSpanProcessor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.ReadWriteSpan;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.ReadableSpan;
import org.rascalmpl.org.rascalmpl.java.io.Closeable;
import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface SpanProcessor
extends Closeable {
    public static SpanProcessor composite(SpanProcessor ... processors) {
        return SpanProcessor.composite((Iterable<SpanProcessor>)Arrays.asList((Object[])processors));
    }

    public static SpanProcessor composite(Iterable<SpanProcessor> processors) {
        ArrayList processorsList = new ArrayList();
        for (SpanProcessor processor : processors) {
            processorsList.add((Object)processor);
        }
        if (processorsList.isEmpty()) {
            return NoopSpanProcessor.getInstance();
        }
        if (processorsList.size() == 1) {
            return (SpanProcessor)processorsList.get(0);
        }
        return MultiSpanProcessor.create((List<SpanProcessor>)processorsList);
    }

    public void onStart(Context var1, ReadWriteSpan var2);

    public boolean isStartRequired();

    public void onEnd(ReadableSpan var1);

    public boolean isEndRequired();

    default public CompletableResultCode shutdown() {
        return this.forceFlush();
    }

    default public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

