/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.data;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.SpanContext;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.trace.SpanKind;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal.InstrumentationScopeUtil;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.resources.Resource;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.data.EventData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.data.LinkData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.data.StatusData;
import org.rascalmpl.org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.Immutable;

@Immutable
public interface SpanData {
    public String getName();

    public SpanKind getKind();

    public SpanContext getSpanContext();

    default public String getTraceId() {
        return this.getSpanContext().getTraceId();
    }

    default public String getSpanId() {
        return this.getSpanContext().getSpanId();
    }

    public SpanContext getParentSpanContext();

    default public String getParentSpanId() {
        return this.getParentSpanContext().getSpanId();
    }

    public StatusData getStatus();

    public long getStartEpochNanos();

    public Attributes getAttributes();

    public List<EventData> getEvents();

    public List<LinkData> getLinks();

    public long getEndEpochNanos();

    public boolean hasEnded();

    public int getTotalRecordedEvents();

    public int getTotalRecordedLinks();

    public int getTotalAttributeCount();

    @Deprecated
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    default public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return InstrumentationScopeUtil.toInstrumentationScopeInfo(this.getInstrumentationLibraryInfo());
    }

    public Resource getResource();
}

