/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.export;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.internal.Utils;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.metrics.MeterProvider;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.export.SpanExporter;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.time.Duration;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;

public final class BatchSpanProcessorBuilder
extends Object {
    static final long DEFAULT_SCHEDULE_DELAY_MILLIS = 5000L;
    static final int DEFAULT_MAX_QUEUE_SIZE = 2048;
    static final int DEFAULT_MAX_EXPORT_BATCH_SIZE = 512;
    static final int DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000;
    private final SpanExporter spanExporter;
    private boolean exportUnsampledSpans = false;
    private long scheduleDelayNanos = TimeUnit.MILLISECONDS.toNanos(5000L);
    private int maxQueueSize = 2048;
    private int maxExportBatchSize = 512;
    private long exporterTimeoutNanos = TimeUnit.MILLISECONDS.toNanos(30000L);
    private MeterProvider meterProvider = MeterProvider.noop();

    BatchSpanProcessorBuilder(SpanExporter spanExporter) {
        this.spanExporter = (SpanExporter)Objects.requireNonNull((Object)spanExporter, (String)"org.rascalmpl.org.rascalmpl.spanExporter");
    }

    public BatchSpanProcessorBuilder setExportUnsampledSpans(boolean exportUnsampledSpans) {
        this.exportUnsampledSpans = exportUnsampledSpans;
        return this;
    }

    public BatchSpanProcessorBuilder setScheduleDelay(long delay, TimeUnit unit) {
        Objects.requireNonNull((Object)unit, (String)"org.rascalmpl.org.rascalmpl.unit");
        Utils.checkArgument(delay >= 0L, (String)"org.rascalmpl.org.rascalmpl.delay must be non-negative");
        this.scheduleDelayNanos = unit.toNanos(delay);
        return this;
    }

    public BatchSpanProcessorBuilder setScheduleDelay(Duration delay) {
        Objects.requireNonNull((Object)delay, (String)"org.rascalmpl.org.rascalmpl.delay");
        return this.setScheduleDelay(delay.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getScheduleDelayNanos() {
        return this.scheduleDelayNanos;
    }

    public BatchSpanProcessorBuilder setExporterTimeout(long timeout, TimeUnit unit) {
        Objects.requireNonNull((Object)unit, (String)"org.rascalmpl.org.rascalmpl.unit");
        Utils.checkArgument(timeout >= 0L, (String)"org.rascalmpl.org.rascalmpl.timeout must be non-negative");
        this.exporterTimeoutNanos = unit.toNanos(timeout);
        return this;
    }

    public BatchSpanProcessorBuilder setExporterTimeout(Duration timeout) {
        Objects.requireNonNull((Object)timeout, (String)"org.rascalmpl.org.rascalmpl.timeout");
        return this.setExporterTimeout(timeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    long getExporterTimeoutNanos() {
        return this.exporterTimeoutNanos;
    }

    public BatchSpanProcessorBuilder setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public BatchSpanProcessorBuilder setMaxExportBatchSize(int maxExportBatchSize) {
        Utils.checkArgument(maxExportBatchSize > 0, (String)"org.rascalmpl.org.rascalmpl.maxExportBatchSize must be positive.");
        this.maxExportBatchSize = maxExportBatchSize;
        return this;
    }

    public BatchSpanProcessorBuilder setMeterProvider(MeterProvider meterProvider) {
        Objects.requireNonNull((Object)meterProvider, (String)"org.rascalmpl.org.rascalmpl.meterProvider");
        this.meterProvider = meterProvider;
        return this;
    }

    int getMaxExportBatchSize() {
        return this.maxExportBatchSize;
    }

    public BatchSpanProcessor build() {
        return new BatchSpanProcessor(this.spanExporter, this.exportUnsampledSpans, this.meterProvider, this.scheduleDelayNanos, this.maxQueueSize, this.maxExportBatchSize, this.exporterTimeoutNanos);
    }
}

