/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.export;

import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.common.CompletableResultCode;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.data.SpanData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.export.SpanExporter;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;

final class MultiSpanExporter
extends Object
implements SpanExporter {
    private static final Logger logger = Logger.getLogger((String)MultiSpanExporter.class.getName());
    private final SpanExporter[] spanExporters;

    static SpanExporter create(List<SpanExporter> spanExporters) {
        return new MultiSpanExporter((SpanExporter[])spanExporters.toArray((Object[])new SpanExporter[0]));
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        ArrayList results = new ArrayList(this.spanExporters.length);
        for (SpanExporter spanExporter : this.spanExporters) {
            CompletableResultCode exportResult;
            try {
                exportResult = spanExporter.export(spans);
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Exception thrown by the export.", (Throwable)((java.lang.Object)e));
                results.add((Object)CompletableResultCode.ofFailure());
                continue;
            }
            results.add((Object)exportResult);
        }
        return CompletableResultCode.ofAll((Collection<CompletableResultCode>)results);
    }

    @Override
    public CompletableResultCode flush() {
        ArrayList results = new ArrayList(this.spanExporters.length);
        for (SpanExporter spanExporter : this.spanExporters) {
            CompletableResultCode flushResult;
            try {
                flushResult = spanExporter.flush();
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Exception thrown by the flush.", (Throwable)((java.lang.Object)e));
                results.add((Object)CompletableResultCode.ofFailure());
                continue;
            }
            results.add((Object)flushResult);
        }
        return CompletableResultCode.ofAll((Collection<CompletableResultCode>)results);
    }

    @Override
    public CompletableResultCode shutdown() {
        ArrayList results = new ArrayList(this.spanExporters.length);
        for (SpanExporter spanExporter : this.spanExporters) {
            CompletableResultCode shutdownResult;
            try {
                shutdownResult = spanExporter.shutdown();
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Exception thrown by the shutdown.", (Throwable)((java.lang.Object)e));
                results.add((Object)CompletableResultCode.ofFailure());
                continue;
            }
            results.add((Object)shutdownResult);
        }
        return CompletableResultCode.ofAll((Collection<CompletableResultCode>)results);
    }

    private MultiSpanExporter(SpanExporter[] spanExporters) {
        this.spanExporters = spanExporters;
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.MultiSpanExporter{spanExporters=").append(Arrays.toString((Object[])this.spanExporters)).append('}').toString();
    }
}

