/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.internal.data;

import org.rascalmpl.org.rascalmpl.com.google.auto.value.AutoValue;
import org.rascalmpl.org.rascalmpl.com.google.auto.value.extension.memoized.Memoized;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.AttributeKey;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.Attributes;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.api.common.AttributesBuilder;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.internal.AttributeUtil;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.SpanLimits;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.internal.data.AutoValue_ImmutableExceptionEventData;
import org.rascalmpl.org.rascalmpl.io.opentelemetry.sdk.trace.internal.data.ExceptionEventData;
import org.rascalmpl.org.rascalmpl.java.io.PrintWriter;
import org.rascalmpl.org.rascalmpl.java.io.StringWriter;
import org.rascalmpl.org.rascalmpl.java.io.Writer;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
abstract class ImmutableExceptionEventData
extends Object
implements ExceptionEventData {
    private static final AttributeKey<String> EXCEPTION_TYPE = AttributeKey.stringKey((String)"org.rascalmpl.org.rascalmpl.exception.type");
    private static final AttributeKey<String> EXCEPTION_MESSAGE = AttributeKey.stringKey((String)"org.rascalmpl.org.rascalmpl.exception.message");
    private static final AttributeKey<String> EXCEPTION_STACKTRACE = AttributeKey.stringKey((String)"org.rascalmpl.org.rascalmpl.exception.stacktrace");
    private static final String EXCEPTION_EVENT_NAME = "org.rascalmpl.org.rascalmpl.exception";

    static ExceptionEventData create(SpanLimits spanLimits, long epochNanos, Throwable exception, Attributes additionalAttributes) {
        return new AutoValue_ImmutableExceptionEventData(epochNanos, exception, additionalAttributes, spanLimits);
    }

    ImmutableExceptionEventData() {
    }

    protected abstract SpanLimits getSpanLimits();

    @Override
    public final String getName() {
        return "org.rascalmpl.org.rascalmpl.exception";
    }

    @Override
    @Memoized
    public Attributes getAttributes() {
        Throwable exception = this.getException();
        Attributes additionalAttributes = this.getAdditionalAttributes();
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributesBuilder.put(EXCEPTION_TYPE, exception.getClass().getCanonicalName());
        String message = exception.getMessage();
        if (message != null) {
            attributesBuilder.put(EXCEPTION_MESSAGE, message);
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter);
        try {
            exception.printStackTrace(printWriter);
        }
        catch (Throwable throwable) {
            try {
                printWriter.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        printWriter.close();
        attributesBuilder.put(EXCEPTION_STACKTRACE, stringWriter.toString());
        attributesBuilder.putAll(additionalAttributes);
        SpanLimits spanLimits = this.getSpanLimits();
        return AttributeUtil.applyAttributesLimit(attributesBuilder.build(), spanLimits.getMaxNumberOfAttributesPerEvent(), spanLimits.getMaxAttributeValueLength());
    }

    @Override
    public final int getTotalAttributeCount() {
        return this.getAttributes().size();
    }
}

