/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.net.bytebuddy.implementation.bytecode.constant;

import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.Float;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.implementation.Implementation;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.implementation.bytecode.StackSize;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FloatConstant
extends Enum<FloatConstant>
implements StackManipulation {
    public static final /* enum */ FloatConstant ZERO = new FloatConstant((String)"org.rascalmpl.org.rascalmpl.ZERO", 0, 11);
    public static final /* enum */ FloatConstant ONE = new FloatConstant((String)"org.rascalmpl.org.rascalmpl.ONE", 1, 12);
    public static final /* enum */ FloatConstant TWO = new FloatConstant((String)"org.rascalmpl.org.rascalmpl.TWO", 2, 13);
    private static final StackManipulation.Size SIZE;
    private final int opcode;
    private static final /* synthetic */ FloatConstant[] $VALUES;

    public static FloatConstant[] values() {
        return (FloatConstant[])$VALUES.clone();
    }

    public static FloatConstant valueOf(String name) {
        return (FloatConstant)Enum.valueOf(FloatConstant.class, (String)name);
    }

    private FloatConstant(int opcode) {
        super((String)string, n);
        this.opcode = opcode;
    }

    public static StackManipulation forValue(float value) {
        if (value == 0.0f) {
            return ZERO;
        }
        if (value == 1.0f) {
            return ONE;
        }
        if (value == 2.0f) {
            return TWO;
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        $VALUES = new FloatConstant[]{ZERO, ONE, TWO};
        SIZE = StackSize.SINGLE.toIncreasingSize();
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ConstantPool
    extends StackManipulation.AbstractBase {
        private final float value;

        protected ConstantPool(float value) {
            this.value = value;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitLdcInsn((Object)Float.valueOf((float)this.value));
            return SIZE;
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return Float.compare((float)this.value, (float)((ConstantPool)object).value) == 0;
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + Float.floatToIntBits((float)this.value);
        }
    }
}

