/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.net.bytebuddy.matcher;

import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.matcher.ElementMatcher;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class CollectionOneToOneMatcher<T extends Object>
extends ElementMatcher.Junction.ForNonNullValues<Iterable<? extends T>> {
    private final List<? extends ElementMatcher<? super T>> matchers;

    public CollectionOneToOneMatcher(List<? extends ElementMatcher<? super T>> matchers) {
        this.matchers = matchers;
    }

    @Override
    protected boolean doMatch(Iterable<? extends T> target) {
        if (target instanceof Collection && ((Collection)target).size() != this.matchers.size()) {
            return false;
        }
        Iterator iterator = this.matchers.iterator();
        for (Object value : target) {
            if (iterator.hasNext() && ((ElementMatcher)iterator.next()).matches(value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder((String)"org.rascalmpl.org.rascalmpl.containing(");
        boolean first = true;
        for (Object value : this.matchers) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append((String)"org.rascalmpl.org.rascalmpl., ");
            }
            stringBuilder.append(value);
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    public boolean equals(@MaybeNull Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.matchers.equals(((CollectionOneToOneMatcher)object).matchers);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.matchers.hashCode();
    }
}

