/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.net.bytebuddy.matcher;

import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.HashSet;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.description.method.MethodDescription;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.description.method.MethodList;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.description.type.TypeDefinition;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.description.type.TypeDescription;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.matcher.ElementMatcher;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.matcher.ElementMatchers;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@HashCodeAndEqualsPlugin.Enhance
public class MethodOverrideMatcher<T extends MethodDescription>
extends ElementMatcher.Junction.ForNonNullValues<T> {
    private final ElementMatcher<? super TypeDescription.Generic> matcher;

    public MethodOverrideMatcher(ElementMatcher<? super TypeDescription.Generic> matcher) {
        this.matcher = matcher;
    }

    @Override
    protected boolean doMatch(T target) {
        HashSet duplicates = new HashSet();
        Iterator iterator = target.getDeclaringType().iterator();
        while (iterator.hasNext()) {
            TypeDefinition typeDefinition = (TypeDefinition)iterator.next();
            if (!this.matches((MethodDescription)((java.lang.Object)target), typeDefinition) && !this.matches((MethodDescription)((java.lang.Object)target), (List<? extends TypeDefinition>)((List<TypeDefinition>)typeDefinition.getInterfaces()), (Set<TypeDescription>)duplicates)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(MethodDescription target, List<? extends TypeDefinition> typeDefinitions, Set<TypeDescription> duplicates) {
        for (TypeDefinition anInterface : typeDefinitions) {
            if (!duplicates.add((Object)anInterface.asErasure()) || !this.matches(target, anInterface) && !this.matches(target, anInterface.getInterfaces(), duplicates)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(MethodDescription target, TypeDefinition typeDefinition) {
        Iterator iterator = ((MethodList)typeDefinition.getDeclaredMethods().filter(ElementMatchers.isVirtual())).iterator();
        while (iterator.hasNext()) {
            MethodDescription methodDescription = (MethodDescription)iterator.next();
            if (!methodDescription.asSignatureToken().equals(target.asSignatureToken())) continue;
            if (!this.matcher.matches(typeDefinition.asGenericType())) break;
            return true;
        }
        return false;
    }

    public String toString() {
        return new StringBuilder().append((String)"org.rascalmpl.org.rascalmpl.isOverriddenFrom(").append(this.matcher).append((String)"org.rascalmpl.org.rascalmpl.)").toString();
    }

    @Override
    public boolean equals(@MaybeNull Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.matcher.equals(((MethodOverrideMatcher)object).matcher);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.matcher.hashCode();
    }
}

