/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.net.bytebuddy.utility;

import org.rascalmpl.org.rascalmpl.java.io.File;
import org.rascalmpl.org.rascalmpl.java.io.FileInputStream;
import org.rascalmpl.org.rascalmpl.java.io.FileOutputStream;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.ClassLoader;
import org.rascalmpl.org.rascalmpl.java.lang.ClassNotFoundException;
import org.rascalmpl.org.rascalmpl.java.lang.SecurityException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.security.AccessController;
import org.rascalmpl.org.rascalmpl.java.security.PrivilegedAction;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.build.AccessControllerPlugin;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.build.CachedReturnPlugin;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.utility.dispatcher.JavaDispatcher;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileSystem
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    private static /* synthetic */ FileSystem INSTANCE;
    private static final boolean ACCESS_CONTROLLER;

    @CachedReturnPlugin.Enhance(value="org.rascalmpl.org.rascalmpl.INSTANCE")
    public static FileSystem getInstance() {
        FileSystem fileSystem;
        FileSystem fileSystem2;
        FileSystem fileSystem3 = INSTANCE;
        if (fileSystem3 != null) {
            fileSystem2 = null;
        } else {
            try {
                Class.forName((String)"org.rascalmpl.org.rascalmpl.java.nio.file.Files", (boolean)false, (ClassLoader)ClassLoadingStrategy.BOOTSTRAP_LOADER);
                fileSystem2 = new ForNio2CapableVm();
            }
            catch (ClassNotFoundException ignored) {
                fileSystem2 = fileSystem = new ForLegacyVm();
            }
        }
        if (fileSystem == null) {
            fileSystem = INSTANCE;
        } else {
            INSTANCE = fileSystem;
        }
        return fileSystem;
    }

    @AccessControllerPlugin.Enhance
    private static <T extends org.rascalmpl.org.rascalmpl.java.lang.Object> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        PrivilegedAction<T> action;
        if (ACCESS_CONTROLLER) {
            return (T)AccessController.doPrivileged(privilegedAction);
        }
        return (T)action.run();
    }

    public abstract void copy(File var1, File var2) throws IOException;

    public abstract void move(File var1, File var2) throws IOException;

    static /* synthetic */ org.rascalmpl.org.rascalmpl.java.lang.Object access$000(PrivilegedAction x0) {
        return FileSystem.doPrivileged(x0);
    }

    static {
        try {
            Class.forName((String)"org.rascalmpl.org.rascalmpl.java.security.AccessController", (boolean)false, null);
            ACCESS_CONTROLLER = Boolean.parseBoolean((String)System.getProperty((String)"org.rascalmpl.org.rascalmpl.net.bytebuddy.securitymanager", (String)"org.rascalmpl.org.rascalmpl.true"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACCESS_CONTROLLER = false;
        }
        catch (SecurityException securityException) {
            ACCESS_CONTROLLER = true;
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ForNio2CapableVm
    extends FileSystem {
        private static final Dispatcher DISPATCHER = (Dispatcher)FileSystem.access$000(JavaDispatcher.of(Dispatcher.class));
        private static final Files FILES = (Files)FileSystem.access$000(JavaDispatcher.of(Files.class));
        private static final StandardCopyOption STANDARD_COPY_OPTION = (StandardCopyOption)FileSystem.access$000(JavaDispatcher.of(StandardCopyOption.class));

        protected ForNio2CapableVm() {
        }

        public void copy(File source, File target) throws IOException {
            org.rascalmpl.org.rascalmpl.java.lang.Object[] option = STANDARD_COPY_OPTION.toArray(1);
            option[0] = STANDARD_COPY_OPTION.valueOf((String)"org.rascalmpl.org.rascalmpl.REPLACE_EXISTING");
            FILES.copy(DISPATCHER.toPath(source), DISPATCHER.toPath(target), option);
        }

        public void move(File source, File target) throws IOException {
            org.rascalmpl.org.rascalmpl.java.lang.Object[] option = STANDARD_COPY_OPTION.toArray(1);
            option[0] = STANDARD_COPY_OPTION.valueOf((String)"org.rascalmpl.org.rascalmpl.REPLACE_EXISTING");
            FILES.move(DISPATCHER.toPath(source), DISPATCHER.toPath(target), option);
        }

        public boolean equals(@MaybeNull org.rascalmpl.org.rascalmpl.java.lang.Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.java.nio.file.StandardCopyOption")
        protected static interface StandardCopyOption {
            @JavaDispatcher.Container
            @JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.toArray")
            public org.rascalmpl.org.rascalmpl.java.lang.Object[] toArray(int var1);

            @JavaDispatcher.IsStatic
            @JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.valueOf")
            public org.rascalmpl.org.rascalmpl.java.lang.Object valueOf(String var1);
        }

        @JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.java.nio.file.Files")
        protected static interface Files {
            @JavaDispatcher.IsStatic
            @JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.copy")
            public org.rascalmpl.org.rascalmpl.java.lang.Object copy(@JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.java.nio.file.Path") org.rascalmpl.org.rascalmpl.java.lang.Object var1, @JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.java.nio.file.Path") org.rascalmpl.org.rascalmpl.java.lang.Object var2, @JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.java.nio.file.CopyOption") org.rascalmpl.org.rascalmpl.java.lang.Object[] var3) throws IOException;

            @JavaDispatcher.IsStatic
            @JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.move")
            public org.rascalmpl.org.rascalmpl.java.lang.Object move(@JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.java.nio.file.Path") org.rascalmpl.org.rascalmpl.java.lang.Object var1, @JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.java.nio.file.Path") org.rascalmpl.org.rascalmpl.java.lang.Object var2, @JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.java.nio.file.CopyOption") org.rascalmpl.org.rascalmpl.java.lang.Object[] var3) throws IOException;
        }

        @JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.java.io.File")
        protected static interface Dispatcher {
            @JavaDispatcher.Proxied(value="org.rascalmpl.org.rascalmpl.toPath")
            public org.rascalmpl.org.rascalmpl.java.lang.Object toPath(File var1) throws IOException;
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    protected static class ForLegacyVm
    extends FileSystem {
        protected ForLegacyVm() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copy(File source, File target) throws IOException {
            FileInputStream inputStream = new FileInputStream(source);
            try {
                FileOutputStream outputStream = new FileOutputStream(target);
                try {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, length);
                    }
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    outputStream.close();
                    throw throwable;
                }
                outputStream.close();
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void move(File source, File target) throws IOException {
            FileInputStream inputStream = new FileInputStream(source);
            try {
                FileOutputStream outputStream = new FileOutputStream(target);
                try {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, length);
                    }
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    outputStream.close();
                    throw throwable;
                }
                outputStream.close();
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            if (!source.delete()) {
                source.deleteOnExit();
            }
        }

        public boolean equals(@MaybeNull org.rascalmpl.org.rascalmpl.java.lang.Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

