/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.net.bytebuddy.utility;

import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.InputStream;
import org.rascalmpl.org.rascalmpl.java.lang.Math;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class StreamDrainer
extends Object {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final StreamDrainer DEFAULT = new StreamDrainer();
    private static final int END_OF_STREAM = -1;
    private static final int FROM_BEGINNING = 0;
    private final int bufferSize;

    public StreamDrainer() {
        this(1024);
    }

    public StreamDrainer(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public byte[] drain(InputStream inputStream) throws IOException {
        int currentRead;
        ArrayList previousBytes = new ArrayList();
        byte[] currentArray = new byte[this.bufferSize];
        int currentIndex = 0;
        do {
            if ((currentIndex += Math.max((int)(currentRead = inputStream.read(currentArray, currentIndex, this.bufferSize - currentIndex)), (int)0)) != this.bufferSize) continue;
            previousBytes.add((Object)currentArray);
            currentArray = new byte[this.bufferSize];
            currentIndex = 0;
        } while (currentRead != -1);
        byte[] result = new byte[previousBytes.size() * this.bufferSize + currentIndex];
        int arrayIndex = 0;
        for (byte[] previousByte : previousBytes) {
            System.arraycopy((Object)previousByte, (int)0, (Object)result, (int)(arrayIndex++ * this.bufferSize), (int)this.bufferSize);
        }
        System.arraycopy((Object)currentArray, (int)0, (Object)result, (int)(arrayIndex * this.bufferSize), (int)currentIndex);
        return result;
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.bufferSize == ((StreamDrainer)object).bufferSize;
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.bufferSize;
    }
}

