/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.net.bytebuddy.utility.visitor;

import org.rascalmpl.org.rascalmpl.edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.rascalmpl.org.rascalmpl.java.lang.Math;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.description.method.MethodDescription;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.jar.asm.MethodVisitor;
import org.rascalmpl.org.rascalmpl.net.bytebuddy.utility.OpenedClassReader;

public class LocalVariableAwareMethodVisitor
extends MethodVisitor {
    private int freeOffset;

    public LocalVariableAwareMethodVisitor(MethodVisitor methodVisitor, MethodDescription methodDescription) {
        super(OpenedClassReader.ASM_API, methodVisitor);
        this.freeOffset = methodDescription.getStackSize();
    }

    @SuppressFBWarnings(value={"org.rascalmpl.org.rascalmpl.SF_SWITCH_NO_DEFAULT"}, justification="org.rascalmpl.org.rascalmpl.No action required on default option.")
    public void visitVarInsn(int opcode, int offset) {
        switch (opcode) {
            case 54: 
            case 56: 
            case 58: {
                this.freeOffset = Math.max((int)this.freeOffset, (int)(offset + 1));
                break;
            }
            case 55: 
            case 57: {
                this.freeOffset = Math.max((int)this.freeOffset, (int)(offset + 2));
            }
        }
        super.visitVarInsn(opcode, offset);
    }

    public int getFreeOffset() {
        return this.freeOffset;
    }
}

