/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.apache.commons.exec;

import org.rascalmpl.org.rascalmpl.java.lang.Deprecated;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalStateException;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalThreadStateException;
import org.rascalmpl.org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.Process;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.time.Duration;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.Executors;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.ThreadFactory;
import org.rascalmpl.org.rascalmpl.java.util.function.Supplier;
import org.rascalmpl.org.rascalmpl.org.apache.commons.exec.TimeoutObserver;
import org.rascalmpl.org.rascalmpl.org.apache.commons.exec.Watchdog;
import org.rascalmpl.org.rascalmpl.org.apache.commons.exec.util.DebugUtils;

public class ExecuteWatchdog
extends Object
implements TimeoutObserver {
    public static final long INFINITE_TIMEOUT = -1L;
    public static final Duration INFINITE_TIMEOUT_DURATION = Duration.ofMillis((long)-1L);
    private Process process;
    private final boolean hasWatchdog;
    private boolean watch = false;
    private Exception caught;
    private boolean killedProcess = false;
    private final Watchdog watchdog;
    private volatile boolean processStarted;
    private final ThreadFactory threadFactory;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public ExecuteWatchdog(long timeoutMillis) {
        this(Executors.defaultThreadFactory(), Duration.ofMillis((long)timeoutMillis));
    }

    private ExecuteWatchdog(ThreadFactory threadFactory, Duration timeout) {
        this.hasWatchdog = !INFINITE_TIMEOUT_DURATION.equals((Object)timeout);
        this.processStarted = false;
        ThreadFactory threadFactory2 = this.threadFactory = threadFactory != null ? threadFactory : Executors.defaultThreadFactory();
        if (this.hasWatchdog) {
            this.watchdog = Watchdog.builder().setThreadFactory(this.threadFactory).setTimeout(timeout).get();
            this.watchdog.addTimeoutObserver(this);
        } else {
            this.watchdog = null;
        }
    }

    public synchronized void checkException() throws Exception {
        if (this.caught != null) {
            throw this.caught;
        }
    }

    protected synchronized void cleanUp() {
        this.watch = false;
        this.process = null;
    }

    public synchronized void destroyProcess() {
        this.ensureStarted();
        this.timeoutOccured(null);
        this.stop();
    }

    private void ensureStarted() {
        while (!this.processStarted && this.caught == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e.getMessage(), (Throwable)((java.lang.Object)e));
            }
        }
    }

    public synchronized void failedToStart(Exception e) {
        this.processStarted = true;
        this.caught = e;
        this.notifyAll();
    }

    public synchronized boolean isWatching() {
        this.ensureStarted();
        return this.watch;
    }

    public synchronized boolean killedProcess() {
        return this.killedProcess;
    }

    void setProcessNotStarted() {
        this.processStarted = false;
    }

    public synchronized void start(Process processToMonitor) {
        Objects.requireNonNull((Object)processToMonitor, (String)"org.rascalmpl.org.rascalmpl.processToMonitor");
        if (this.process != null) {
            throw new IllegalStateException((String)"org.rascalmpl.org.rascalmpl.Already running.");
        }
        this.caught = null;
        this.killedProcess = false;
        this.watch = true;
        this.process = processToMonitor;
        this.processStarted = true;
        this.notifyAll();
        if (this.hasWatchdog) {
            this.watchdog.start();
        }
    }

    public synchronized void stop() {
        if (this.hasWatchdog) {
            this.watchdog.stop();
        }
        this.watch = false;
        this.process = null;
    }

    @Override
    public synchronized void timeoutOccured(Watchdog w) {
        try {
            try {
                if (this.process != null) {
                    this.process.exitValue();
                }
            }
            catch (IllegalThreadStateException itse) {
                if (this.watch) {
                    this.killedProcess = true;
                    this.process.destroy();
                }
            }
        }
        catch (Exception e) {
            this.caught = e;
            DebugUtils.handleException((String)"org.rascalmpl.org.rascalmpl.Getting the exit value of the process failed", e);
        }
        finally {
            this.cleanUp();
        }
    }

    public static final class Builder
    extends Object
    implements Supplier<ExecuteWatchdog> {
        private ThreadFactory threadFactory;
        private Duration timeout;

        public ExecuteWatchdog get() {
            return new ExecuteWatchdog(this.threadFactory, this.timeout);
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }
    }
}

