/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium;

import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.InputStream;
import org.rascalmpl.org.rascalmpl.java.lang.NullPointerException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.net.URL;
import org.rascalmpl.org.rascalmpl.java.util.Properties;

public class BuildInfo
extends Object {
    private static final Properties BUILD_PROPERTIES = BuildInfo.loadBuildProperties();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties loadBuildProperties() {
        Properties properties = new Properties();
        URL resource = BuildInfo.class.getResource((String)"org/rascalmpl/org/rascalmpl//META-INF/selenium-build.properties");
        try {
            InputStream is = resource.openStream();
            try {
                properties.load(is);
                if (is == null) return properties;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            is.close();
            return properties;
        }
        catch (IOException | NullPointerException throwable) {
            // empty catch block
        }
        return properties;
    }

    public String getReleaseLabel() {
        return this.read((String)"org.rascalmpl.org.rascalmpl.Selenium-Version");
    }

    public String getBuildRevision() {
        return this.read((String)"org.rascalmpl.org.rascalmpl.Build-Revision");
    }

    public String toString() {
        return String.format((String)"org.rascalmpl.org.rascalmpl.Build info: version: '%s', revision: '%s'", (Object[])new Object[]{this.getReleaseLabel(), this.getBuildRevision()});
    }

    private String read(String propertyName) {
        String value = BUILD_PROPERTIES.getProperty(propertyName);
        if (value == null || value.trim().isEmpty()) {
            return "org.rascalmpl.org.rascalmpl.unknown";
        }
        return value.trim();
    }
}

