/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium;

import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Character;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.java.util.regex.Pattern;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.InvalidSelectorException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.JavascriptExecutor;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.NoSuchElementException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.SearchContext;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriver;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebElement;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WrapsDriver;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.internal.Require;

public abstract class By
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    public static By id(String id) {
        return new ById(id);
    }

    public static By linkText(String linkText) {
        return new ByLinkText(linkText);
    }

    public static By partialLinkText(String partialLinkText) {
        return new ByPartialLinkText(partialLinkText);
    }

    public static By name(String name) {
        return new ByName(name);
    }

    public static By tagName(String tagName) {
        return new ByTagName(tagName);
    }

    public static By xpath(String xpathExpression) {
        return new ByXPath(xpathExpression);
    }

    public static By className(String className) {
        return new ByClassName(className);
    }

    public static By cssSelector(String cssSelector) {
        return new ByCssSelector(cssSelector);
    }

    public WebElement findElement(SearchContext context) {
        List<WebElement> allElements = this.findElements(context);
        if (allElements == null || allElements.isEmpty()) {
            throw new NoSuchElementException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Cannot locate an element using \u0001"}, (String)this.toString()));
        }
        return (WebElement)allElements.get(0);
    }

    public abstract List<WebElement> findElements(SearchContext var1);

    protected WebDriver getWebDriver(SearchContext context) {
        if (context instanceof WebDriver) {
            return (WebDriver)context;
        }
        if (!(context instanceof WrapsDriver)) {
            throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Context does not wrap a webdriver: \u0001"}, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)context)));
        }
        return ((WrapsDriver)((Object)context)).getWrappedDriver();
    }

    protected JavascriptExecutor getJavascriptExecutor(SearchContext context) {
        WebDriver driver = this.getWebDriver(context);
        if (!(context instanceof JavascriptExecutor)) {
            throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Context does not provide a mechanism to execute JS: \u0001"}, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)context)));
        }
        return (JavascriptExecutor)((Object)driver);
    }

    public boolean equals(org.rascalmpl.org.rascalmpl.java.lang.Object o) {
        if (!(o instanceof By)) {
            return false;
        }
        By that = (By)o;
        return this.toString().equals((org.rascalmpl.org.rascalmpl.java.lang.Object)that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "org.rascalmpl.org.rascalmpl.[unknown locator]";
    }

    public static class ById
    extends PreW3CLocator {
        private final String id;

        public ById(String id) {
            super((String)"org.rascalmpl.org.rascalmpl.id", Require.argument((String)"org.rascalmpl.org.rascalmpl.Id", id).nonNull((String)"org.rascalmpl.org.rascalmpl.Cannot find elements when id is null.", new org.rascalmpl.org.rascalmpl.java.lang.Object[0]), (String)"org.rascalmpl.org.rascalmpl.#%s");
            this.id = id;
        }

        @Override
        public String toString() {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.By.id: \u0001"}, (String)this.id);
        }
    }

    public static class ByLinkText
    extends BaseW3CLocator {
        private final String linkText;

        public ByLinkText(String linkText) {
            super((String)"org.rascalmpl.org.rascalmpl.link text", Require.argument((String)"org.rascalmpl.org.rascalmpl.Link text", linkText).nonNull((String)"org.rascalmpl.org.rascalmpl.Cannot find elements when the link text is null.", new org.rascalmpl.org.rascalmpl.java.lang.Object[0]));
            this.linkText = linkText;
        }

        @Override
        public String toString() {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.By.linkText: \u0001"}, (String)this.linkText);
        }
    }

    public static class ByPartialLinkText
    extends BaseW3CLocator {
        private final String partialLinkText;

        public ByPartialLinkText(String partialLinkText) {
            super((String)"org.rascalmpl.org.rascalmpl.partial link text", Require.argument((String)"org.rascalmpl.org.rascalmpl.Partial link text", partialLinkText).nonNull((String)"org.rascalmpl.org.rascalmpl.Cannot find elements when the link text is null.", new org.rascalmpl.org.rascalmpl.java.lang.Object[0]));
            this.partialLinkText = partialLinkText;
        }

        @Override
        public String toString() {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.By.partialLinkText: \u0001"}, (String)this.partialLinkText);
        }
    }

    public static class ByName
    extends PreW3CLocator {
        private final String name;

        public ByName(String name) {
            super((String)"org.rascalmpl.org.rascalmpl.name", Require.argument((String)"org.rascalmpl.org.rascalmpl.Name", name).nonNull((String)"org.rascalmpl.org.rascalmpl.Cannot find elements when name text is null.", new org.rascalmpl.org.rascalmpl.java.lang.Object[0]), String.format((String)"org.rascalmpl.org.rascalmpl.*[name='%s']", (org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{name.replace((CharSequence)"org.rascalmpl.org.rascalmpl.'", (CharSequence)"org.rascalmpl.org.rascalmpl.\\'")}));
            this.name = name;
        }

        @Override
        public String toString() {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.By.name: \u0001"}, (String)this.name);
        }
    }

    public static class ByTagName
    extends BaseW3CLocator {
        private final String tagName;

        public ByTagName(String tagName) {
            super((String)"org.rascalmpl.org.rascalmpl.tag name", Require.argument((String)"org.rascalmpl.org.rascalmpl.Tag name", tagName).nonNull((String)"org.rascalmpl.org.rascalmpl.Cannot find elements when the tag name is null.", new org.rascalmpl.org.rascalmpl.java.lang.Object[0]));
            if (tagName.isEmpty()) {
                throw new InvalidSelectorException((String)"org.rascalmpl.org.rascalmpl.Tag name must not be blank");
            }
            this.tagName = tagName;
        }

        @Override
        public String toString() {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.By.tagName: \u0001"}, (String)this.tagName);
        }
    }

    public static class ByXPath
    extends BaseW3CLocator {
        private final String xpathExpression;

        public ByXPath(String xpathExpression) {
            super((String)"org.rascalmpl.org.rascalmpl.xpath", Require.argument((String)"org.rascalmpl.org.rascalmpl.XPath", xpathExpression).nonNull((String)"org.rascalmpl.org.rascalmpl.Cannot find elements when the XPath is null.", new org.rascalmpl.org.rascalmpl.java.lang.Object[0]));
            this.xpathExpression = xpathExpression;
        }

        @Override
        public String toString() {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.By.xpath: \u0001"}, (String)this.xpathExpression);
        }
    }

    public static class ByClassName
    extends PreW3CLocator {
        private final String className;

        public ByClassName(String className) {
            super((String)"org.rascalmpl.org.rascalmpl.class name", Require.argument((String)"org.rascalmpl.org.rascalmpl.Class name", className).nonNull((String)"org.rascalmpl.org.rascalmpl.Cannot find elements when the class name expression is null.", new org.rascalmpl.org.rascalmpl.java.lang.Object[0]), (String)"org.rascalmpl.org.rascalmpl..%s");
            if (className.matches((String)"org.rascalmpl.org.rascalmpl..*\\s.*")) {
                throw new InvalidSelectorException((String)"org.rascalmpl.org.rascalmpl.Compound class names not permitted");
            }
            this.className = className;
        }

        @Override
        public String toString() {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.By.className: \u0001"}, (String)this.className);
        }
    }

    public static class ByCssSelector
    extends BaseW3CLocator {
        private final String cssSelector;

        public ByCssSelector(String cssSelector) {
            super((String)"org.rascalmpl.org.rascalmpl.css selector", Require.argument((String)"org.rascalmpl.org.rascalmpl.CSS selector", cssSelector).nonNull((String)"org.rascalmpl.org.rascalmpl.Cannot find elements when the selector is null", new org.rascalmpl.org.rascalmpl.java.lang.Object[0]));
            this.cssSelector = cssSelector;
        }

        @Override
        public String toString() {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.By.cssSelector: \u0001"}, (String)this.cssSelector);
        }
    }

    private static abstract class PreW3CLocator
    extends By
    implements Remotable {
        private static final Pattern CSS_ESCAPE = Pattern.compile((String)"org/rascalmpl/org/rascalmpl/([\\s'\"\\\\#.:;,!?+<>=~*^$|%&@`{}\\-\\/\\[\\]\\(\\)])");
        private final Remotable.Parameters remoteParams;
        private final ByCssSelector fallback;

        private PreW3CLocator(String using, String value, String formatString) {
            this.remoteParams = new Remotable.Parameters(using, (org.rascalmpl.org.rascalmpl.java.lang.Object)value);
            this.fallback = new ByCssSelector(String.format((String)formatString, (org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{this.cssEscape(value)}));
        }

        @Override
        public WebElement findElement(SearchContext context) {
            return context.findElement(this.fallback);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            return context.findElements(this.fallback);
        }

        @Override
        public final Remotable.Parameters getRemoteParameters() {
            return this.remoteParams;
        }

        protected final Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object> toJson() {
            return this.fallback.toJson();
        }

        private String cssEscape(String using) {
            if (!(using = CSS_ESCAPE.matcher((CharSequence)using).replaceAll((String)"org.rascalmpl.org.rascalmpl.\\\\$1")).isEmpty() && Character.isDigit((char)using.charAt(0))) {
                using = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.\\\u0001 \u0001"}, (int)(30 + Integer.parseInt((String)using.substring(0, 1))), (String)using.substring(1));
            }
            return using;
        }
    }

    private static abstract class BaseW3CLocator
    extends By
    implements Remotable {
        private final Remotable.Parameters params;

        protected BaseW3CLocator(String using, String value) {
            this.params = new Remotable.Parameters(using, (org.rascalmpl.org.rascalmpl.java.lang.Object)value);
        }

        @Override
        public WebElement findElement(SearchContext context) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Search Context", context);
            return context.findElement(this);
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Search Context", context);
            return context.findElements(this);
        }

        @Override
        public final Remotable.Parameters getRemoteParameters() {
            return this.params;
        }

        protected final Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object> toJson() {
            return this.getRemoteParameters().toJson();
        }
    }

    public static interface Remotable {
        public Parameters getRemoteParameters();

        public static class Parameters
        extends org.rascalmpl.org.rascalmpl.java.lang.Object {
            private final String using;
            private final org.rascalmpl.org.rascalmpl.java.lang.Object value;

            public Parameters(String using, org.rascalmpl.org.rascalmpl.java.lang.Object value) {
                this.using = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Search mechanism", using);
                this.value = value;
            }

            public String using() {
                return this.using;
            }

            public org.rascalmpl.org.rascalmpl.java.lang.Object value() {
                return this.value;
            }

            public String toString() {
                return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.[\u0001: \u0001]"}, (String)this.using, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)this.value));
            }

            public boolean equals(org.rascalmpl.org.rascalmpl.java.lang.Object o) {
                if (!(o instanceof Parameters)) {
                    return false;
                }
                Parameters that = (Parameters)o;
                return this.using.equals((org.rascalmpl.org.rascalmpl.java.lang.Object)that.using) && Objects.equals((org.rascalmpl.org.rascalmpl.java.lang.Object)this.value, (org.rascalmpl.org.rascalmpl.java.lang.Object)that.value);
            }

            public int hashCode() {
                return Objects.hash((org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{this.using, this.value});
            }

            private Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object> toJson() {
                HashMap params = new HashMap();
                params.put((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.using", (org.rascalmpl.org.rascalmpl.java.lang.Object)this.using);
                params.put((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.value", this.value);
                return Collections.unmodifiableMap((Map)params);
            }
        }
    }
}

