/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.chrome;

import org.rascalmpl.org.rascalmpl.com.google.auto.service.AutoService;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.Optional;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.Capabilities;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.ImmutableCapabilities;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.SessionNotCreatedException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriver;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriverInfo;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.chrome.ChromeDriver;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.chrome.ChromeDriverService;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.chrome.ChromeOptions;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.chromium.ChromiumDriverInfo;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.Browser;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.service.DriverFinder;

@AutoService(value={WebDriverInfo.class})
public class ChromeDriverInfo
extends ChromiumDriverInfo {
    private static final Logger LOG = Logger.getLogger((String)ChromeDriverInfo.class.getName());

    @Override
    public String getDisplayName() {
        return "org.rascalmpl.org.rascalmpl.Chrome";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities((String)"org.rascalmpl.org.rascalmpl.browserName", (Object)Browser.CHROME.browserName());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return Browser.CHROME.is(capabilities) || capabilities.getCapability((String)"org.rascalmpl.org.rascalmpl.goog:chromeOptions") != null;
    }

    @Override
    public boolean isSupportingCdp() {
        return true;
    }

    @Override
    public boolean isSupportingBiDi() {
        return true;
    }

    @Override
    public boolean isAvailable() {
        return new DriverFinder(ChromeDriverService.createDefaultService(), this.getCanonicalCapabilities()).isAvailable();
    }

    @Override
    public boolean isPresent() {
        return new DriverFinder(ChromeDriverService.createDefaultService(), this.getCanonicalCapabilities()).isPresent();
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        ChromeDriver driver = new ChromeDriver(new ChromeOptions().merge(capabilities));
        return Optional.of((Object)driver);
    }
}

