/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.devtools;

import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.ClassLoader;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.NumberFormatException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Optional;
import org.rascalmpl.org.rascalmpl.java.util.ServiceLoader;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.java.util.Spliterator;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.java.util.regex.Matcher;
import org.rascalmpl.org.rascalmpl.java.util.regex.Pattern;
import org.rascalmpl.org.rascalmpl.java.util.stream.Collectors;
import org.rascalmpl.org.rascalmpl.java.util.stream.StreamSupport;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.devtools.CdpInfo;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.internal.Require;

public class CdpVersionFinder
extends Object {
    private static final Logger LOG = Logger.getLogger((String)CdpVersionFinder.class.getName());
    private final int fudgeFactor;
    private final Set<CdpInfo> infos;
    private static final Pattern MAJOR_VERSION_EXTRACTOR = Pattern.compile((String)"org/rascalmpl/org/rascalmpl/.*/(\\d+)\\..*");
    private static final Pattern BROWSER_NAME_VERSION = Pattern.compile((String)"org.rascalmpl.org.rascalmpl.(\\d+)\\..*");

    public CdpVersionFinder() {
        this(5, (Collection<CdpInfo>)((Collection)StreamSupport.stream((Spliterator)ServiceLoader.load(CdpInfo.class, (ClassLoader)CdpVersionFinder.class.getClassLoader()).spliterator(), (boolean)false).collect(Collectors.toSet())));
    }

    public CdpVersionFinder(int versionFudgeFactor, Collection<CdpInfo> infos) {
        this.fudgeFactor = Require.nonNegative((String)"org.rascalmpl.org.rascalmpl.Version fudge factor", Integer.valueOf((int)versionFudgeFactor));
        Require.nonNull((String)"org.rascalmpl.org.rascalmpl.CDP versions", infos);
        this.infos = Set.copyOf(infos);
    }

    public Optional<CdpInfo> match(Map<String, Object> versionJson) {
        Require.nonNull((String)"org.rascalmpl.org.rascalmpl.JSON", versionJson);
        Object rawBrowser = versionJson.get((Object)"org.rascalmpl.org.rascalmpl.Browser");
        if (!(rawBrowser instanceof String)) {
            return Optional.empty();
        }
        Matcher matcher = MAJOR_VERSION_EXTRACTOR.matcher((CharSequence)rawBrowser.toString());
        return this.fromMatcher(matcher);
    }

    public Optional<CdpInfo> match(String browserVersion) {
        Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Browser version", browserVersion);
        Matcher matcher = BROWSER_NAME_VERSION.matcher((CharSequence)browserVersion);
        return this.fromMatcher(matcher);
    }

    private Optional<CdpInfo> fromMatcher(Matcher matcher) {
        if (matcher.matches()) {
            String major = matcher.group(1);
            try {
                int version = Integer.parseInt((String)major);
                return this.findNearestMatch(version);
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<CdpInfo> findNearestMatch(int version) {
        CdpInfo nearestMatch = null;
        for (CdpInfo info : this.infos) {
            if (info.getMajorVersion() == version) {
                LOG.log(Level.FINE, (String)"org.rascalmpl.org.rascalmpl.Found exact CDP implementation for version {0}", (Object)Integer.valueOf((int)version));
                return Optional.of((Object)info);
            }
            if (info.getMajorVersion() > version || version - info.getMajorVersion() >= this.fudgeFactor || nearestMatch != null && info.getMajorVersion() <= nearestMatch.getMajorVersion()) continue;
            nearestMatch = info;
        }
        if (nearestMatch == null) {
            LOG.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Unable to find CDP implementation matching {0}", (Object)Integer.valueOf((int)version));
        } else {
            LOG.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Unable to find an exact match for CDP version {0}, returning the closest version; found: {1}; Please update to a Selenium version that supports CDP version {0}", new Object[]{Integer.valueOf((int)version), Integer.valueOf((int)nearestMatch.getMajorVersion())});
        }
        return Optional.ofNullable(nearestMatch);
    }
}

