/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.firefox;

import org.rascalmpl.org.rascalmpl.java.io.BufferedInputStream;
import org.rascalmpl.org.rascalmpl.java.io.BufferedReader;
import org.rascalmpl.org.rascalmpl.java.io.File;
import org.rascalmpl.org.rascalmpl.java.io.FileInputStream;
import org.rascalmpl.org.rascalmpl.java.io.FileNotFoundException;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.InputStream;
import org.rascalmpl.org.rascalmpl.java.io.Reader;
import org.rascalmpl.org.rascalmpl.java.io.UncheckedIOException;
import org.rascalmpl.org.rascalmpl.java.lang.Exception;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.CallSite;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.org.rascalmpl.java.nio.charset.StandardCharsets;
import org.rascalmpl.org.rascalmpl.java.nio.file.Files;
import org.rascalmpl.org.rascalmpl.java.nio.file.Path;
import org.rascalmpl.org.rascalmpl.java.util.Iterator;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.javax.xml.namespace.NamespaceContext;
import org.rascalmpl.org.rascalmpl.javax.xml.parsers.DocumentBuilder;
import org.rascalmpl.org.rascalmpl.javax.xml.parsers.DocumentBuilderFactory;
import org.rascalmpl.org.rascalmpl.javax.xml.xpath.XPath;
import org.rascalmpl.org.rascalmpl.javax.xml.xpath.XPathConstants;
import org.rascalmpl.org.rascalmpl.javax.xml.xpath.XPathFactory;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.firefox.Extension;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.io.FileHandler;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.io.TemporaryFilesystem;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.io.Zip;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.json.Json;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.json.JsonInput;
import org.rascalmpl.org.rascalmpl.org.w3c.dom.Document;
import org.rascalmpl.org.rascalmpl.org.w3c.dom.Node;

public class FileExtension
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements Extension {
    private static final String EM_NAMESPACE_URI = "org/rascalmpl/org/rascalmpl/http://www.mozilla.org/2004/em-rdf#";
    private final File toInstall;

    public FileExtension(File toInstall) {
        this.toInstall = toInstall;
    }

    @Override
    public void writeTo(File extensionsDir) throws IOException {
        if (!this.toInstall.isDirectory() && !FileHandler.isZipped(this.toInstall.getAbsolutePath())) {
            throw new IOException(String.format((String)"org.rascalmpl.org.rascalmpl.Can only install from a zip file, an XPI or a directory: %s", (org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{this.toInstall.getAbsolutePath()}));
        }
        if (this.toInstall.isDirectory()) {
            this.installExtensionFromDirectoryTo(extensionsDir);
        } else {
            this.installExtensionFromFileTo(extensionsDir);
        }
    }

    private void installExtensionFromDirectoryTo(File extensionsDir) throws IOException {
        String id = this.getExtensionId(this.toInstall);
        File target = new File(extensionsDir, id);
        if (target.exists() && !FileHandler.delete(target)) {
            throw new IOException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Unable to delete existing extension directory: \u0001"}, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)target)));
        }
        FileHandler.createDir(target);
        FileHandler.makeWritable(target);
        FileHandler.copy(this.toInstall, target);
    }

    private void installExtensionFromFileTo(File extensionsDir) throws IOException {
        File unpackedExt = this.obtainRootDirectory(this.toInstall);
        String id = this.getExtensionId(unpackedExt);
        File target = new File(extensionsDir, (String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.\u0001.xpi"}, (String)id));
        if (target.exists() && !FileHandler.delete(target)) {
            throw new IOException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Unable to delete existing extension file: \u0001"}, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)target)));
        }
        FileHandler.createDir(extensionsDir);
        FileHandler.makeWritable(extensionsDir);
        FileHandler.copy(this.toInstall, target);
        TemporaryFilesystem.getDefaultTmpFS().deleteTempDir(unpackedExt);
    }

    private File obtainRootDirectory(File extensionToInstall) throws IOException {
        File root = extensionToInstall;
        if (!extensionToInstall.isDirectory()) {
            BufferedInputStream bis = new BufferedInputStream((InputStream)new FileInputStream(extensionToInstall));
            try {
                root = Zip.unzipToTempDir((InputStream)bis, (String)"org.rascalmpl.org.rascalmpl.unzip", (String)"org.rascalmpl.org.rascalmpl.stream");
            }
            catch (Throwable throwable) {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            bis.close();
        }
        return root;
    }

    private String getExtensionId(File root) {
        File manifestJson = new File(root, (String)"org.rascalmpl.org.rascalmpl.manifest.json");
        File installRdf = new File(root, (String)"org.rascalmpl.org.rascalmpl.install.rdf");
        if (installRdf.exists()) {
            return this.readIdFromInstallRdf(root);
        }
        if (manifestJson.exists()) {
            return this.readIdFromManifestJson(root);
        }
        throw new WebDriverException((String)"org.rascalmpl.org.rascalmpl.Extension should contain either install.rdf or manifest.json metadata file");
    }

    /*
     * Loose catch block
     */
    private String readIdFromManifestJson(File root) {
        CallSite callSite;
        JsonInput json;
        BufferedReader reader;
        block18: {
            Map geckoObj;
            Map applicationObj;
            java.lang.String MANIFEST_JSON_FILE = "org.rascalmpl.org.rascalmpl.manifest.json";
            File manifestJsonFile = new File(root, (String)"org.rascalmpl.org.rascalmpl.manifest.json");
            reader = Files.newBufferedReader((Path)manifestJsonFile.toPath(), (Charset)StandardCharsets.UTF_8);
            json = new Json().newInput((Reader)reader);
            CallSite addOnId = null;
            Map manifestObject = (Map)json.read(Json.MAP_TYPE);
            if (manifestObject.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.applications") instanceof Map && (applicationObj = (Map)manifestObject.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.applications")).get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.gecko") instanceof Map && (geckoObj = (Map)applicationObj.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.gecko")).get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.id") instanceof String) {
                addOnId = ((String)geckoObj.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.id")).trim();
            }
            if (addOnId == null || addOnId.isEmpty()) {
                addOnId = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.\u0001@\u0001"}, (String)((String)manifestObject.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.name")).replaceAll((String)"org.rascalmpl.org.rascalmpl. ", (String)"org.rascalmpl.org.rascalmpl."), (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)manifestObject.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.version")));
            }
            callSite = addOnId;
            if (json != null) {
                json.close();
            }
            if (reader == null) break block18;
            reader.close();
        }
        return callSite;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (json != null) {
                            try {
                                json.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (FileNotFoundException e1) {
                    throw new WebDriverException((String)"org.rascalmpl.org.rascalmpl.Unable to file manifest.json in xpi file");
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    private String readIdFromInstallRdf(File root) {
        try {
            String id;
            File installRdf = new File(root, (String)"org.rascalmpl.org.rascalmpl.install.rdf");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature((String)"org/rascalmpl/org/rascalmpl/http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setNamespaceAware(true);
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(installRdf);
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                public String getNamespaceURI(String prefix) {
                    if ("org.rascalmpl.org.rascalmpl.em".equals((org.rascalmpl.org.rascalmpl.java.lang.Object)prefix)) {
                        return "org/rascalmpl/org/rascalmpl/http://www.mozilla.org/2004/em-rdf#";
                    }
                    if ("org.rascalmpl.org.rascalmpl.RDF".equals((org.rascalmpl.org.rascalmpl.java.lang.Object)prefix)) {
                        return "org/rascalmpl/org/rascalmpl/http://www.w3.org/1999/02/22-rdf-syntax-ns#";
                    }
                    return "org.rascalmpl.org.rascalmpl.";
                }

                public String getPrefix(String uri) {
                    throw new UnsupportedOperationException((String)"org.rascalmpl.org.rascalmpl.getPrefix");
                }

                public Iterator<String> getPrefixes(String uri) {
                    throw new UnsupportedOperationException((String)"org.rascalmpl.org.rascalmpl.getPrefixes");
                }
            });
            Node idNode = (Node)xpath.compile((String)"org/rascalmpl/org/rascalmpl///em:id").evaluate((org.rascalmpl.org.rascalmpl.java.lang.Object)doc, XPathConstants.NODE);
            if (idNode == null) {
                Node descriptionNode = (Node)xpath.compile((String)"org/rascalmpl/org/rascalmpl///RDF:Description").evaluate((org.rascalmpl.org.rascalmpl.java.lang.Object)doc, XPathConstants.NODE);
                Node idAttr = descriptionNode.getAttributes().getNamedItemNS((String)"org/rascalmpl/org/rascalmpl/http://www.mozilla.org/2004/em-rdf#", (String)"org.rascalmpl.org.rascalmpl.id");
                if (idAttr == null) {
                    throw new WebDriverException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Cannot locate node containing extension id: \u0001"}, (String)installRdf.getAbsolutePath()));
                }
                id = idAttr.getNodeValue();
            } else {
                id = idNode.getTextContent();
            }
            if (id == null || id.trim().isEmpty()) {
                throw new FileNotFoundException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Cannot install extension with ID: \u0001"}, (String)id));
            }
            return id;
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)((Object)e));
        }
    }
}

