/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.firefox;

import org.rascalmpl.org.rascalmpl.java.io.File;
import org.rascalmpl.org.rascalmpl.java.io.FileOutputStream;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.org.rascalmpl.java.io.OutputStreamWriter;
import org.rascalmpl.org.rascalmpl.java.io.Reader;
import org.rascalmpl.org.rascalmpl.java.io.StringReader;
import org.rascalmpl.org.rascalmpl.java.io.Writer;
import org.rascalmpl.org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Type;
import org.rascalmpl.org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.firefox.ClasspathExtension;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.firefox.Extension;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.firefox.FileExtension;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.firefox.Preferences;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.firefox.UnableToCreateProfileException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.io.FileHandler;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.io.TemporaryFilesystem;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.io.Zip;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.json.Json;

public class FirefoxProfile
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    private static final String ACCEPT_UNTRUSTED_CERTS_PREF = "org.rascalmpl.org.rascalmpl.webdriver_accept_untrusted_certs";
    private static final String ASSUME_UNTRUSTED_ISSUER_PREF = "org.rascalmpl.org.rascalmpl.webdriver_assume_untrusted_issuer";
    private final Preferences additionalPrefs;
    private final Map<String, Extension> extensions = new HashMap();
    private final File model;
    private boolean loadNoFocusLib;
    private boolean acceptUntrustedCerts;
    private boolean untrustedCertIssuer;

    public FirefoxProfile() {
        this(null);
    }

    public FirefoxProfile(File profileDir) {
        this.additionalPrefs = new Preferences();
        this.model = profileDir;
        this.verifyModel(this.model);
        File prefsInModel = new File(this.model, (String)"org.rascalmpl.org.rascalmpl.user.js");
        if (prefsInModel.exists()) {
            StringReader reader = new StringReader((String)"org.rascalmpl.org.rascalmpl.{\"frozen\": {}, \"mutable\": {}}");
            Preferences existingPrefs = new Preferences((Reader)reader, prefsInModel);
            existingPrefs.addTo(this.additionalPrefs);
            this.acceptUntrustedCerts = this.getBooleanPreference(existingPrefs, (String)"org.rascalmpl.org.rascalmpl.webdriver_accept_untrusted_certs", true);
            this.untrustedCertIssuer = this.getBooleanPreference(existingPrefs, (String)"org.rascalmpl.org.rascalmpl.webdriver_assume_untrusted_issuer", true);
        } else {
            this.acceptUntrustedCerts = true;
            this.untrustedCertIssuer = true;
        }
        this.loadNoFocusLib = false;
    }

    public static FirefoxProfile fromJson(String json) throws IOException {
        if (json.trim().startsWith((String)"org.rascalmpl.org.rascalmpl.\"")) {
            json = (String)new Json().toType(json, (Type)String.class);
        }
        return new FirefoxProfile(Zip.unzipToTempDir(json, (String)"org.rascalmpl.org.rascalmpl.webdriver", (String)"org.rascalmpl.org.rascalmpl.duplicated"));
    }

    private boolean getBooleanPreference(Preferences prefs, String key, boolean defaultValue) {
        org.rascalmpl.org.rascalmpl.java.lang.Object value = prefs.getPreference(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).booleanValue();
        }
        throw new WebDriverException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Expected boolean value is not a boolean. It is: \u0001"}, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)value)));
    }

    public String getStringPreference(String key, String defaultValue) {
        org.rascalmpl.org.rascalmpl.java.lang.Object preference = this.additionalPrefs.getPreference(key);
        if (preference instanceof String) {
            return (String)preference;
        }
        return defaultValue;
    }

    public int getIntegerPreference(String key, int defaultValue) {
        org.rascalmpl.org.rascalmpl.java.lang.Object preference = this.additionalPrefs.getPreference(key);
        if (preference instanceof Integer) {
            return ((Integer)preference).intValue();
        }
        return defaultValue;
    }

    public boolean getBooleanPreference(String key, boolean defaultValue) {
        org.rascalmpl.org.rascalmpl.java.lang.Object preference = this.additionalPrefs.getPreference(key);
        if (preference instanceof Boolean) {
            return ((Boolean)preference).booleanValue();
        }
        return defaultValue;
    }

    private void verifyModel(File model) {
        if (model == null) {
            return;
        }
        if (!model.exists()) {
            throw new UnableToCreateProfileException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Given model profile directory does not exist: \u0001"}, (String)model.getPath()));
        }
        if (!model.isDirectory()) {
            throw new UnableToCreateProfileException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.Given model profile directory is not a directory: \u0001"}, (String)model.getAbsolutePath()));
        }
    }

    public boolean containsWebDriverExtension() {
        return this.extensions.containsKey((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.webdriver");
    }

    public void addExtension(Class<?> loadResourcesUsing, String loadFrom) {
        File file = new File(loadFrom);
        if (file.exists()) {
            this.addExtension(file);
            return;
        }
        this.addExtension(loadFrom, new ClasspathExtension(loadResourcesUsing, loadFrom));
    }

    public void addExtension(File extensionToInstall) {
        this.addExtension(extensionToInstall.getName(), new FileExtension(extensionToInstall));
    }

    public void addExtension(String key, Extension extension) {
        String name = this.deriveExtensionName(key);
        this.extensions.put((org.rascalmpl.org.rascalmpl.java.lang.Object)name, (org.rascalmpl.org.rascalmpl.java.lang.Object)extension);
    }

    private String deriveExtensionName(String originalName) {
        String[] pieces = originalName.replace('\\', '/').split((String)"org/rascalmpl/org/rascalmpl//");
        String name = pieces[pieces.length - 1];
        name = name.replaceAll((String)"org.rascalmpl.org.rascalmpl.\\..*?$", (String)"org.rascalmpl.org.rascalmpl.");
        return name;
    }

    public void setPreference(String key, org.rascalmpl.org.rascalmpl.java.lang.Object value) {
        this.additionalPrefs.setPreference(key, value);
    }

    protected Preferences getAdditionalPreferences() {
        return this.additionalPrefs;
    }

    public void updateUserPrefs(File userPrefs) {
        Preferences prefs = new Preferences();
        prefs.setPreference((String)"org.rascalmpl.org.rascalmpl.browser.startup.homepage", (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.about:blank");
        prefs.setPreference((String)"org.rascalmpl.org.rascalmpl.browser.startup.page", (org.rascalmpl.org.rascalmpl.java.lang.Object)Integer.valueOf((int)0));
        if (userPrefs.exists()) {
            prefs = new Preferences(userPrefs);
            if (!userPrefs.delete()) {
                throw new WebDriverException((String)"org.rascalmpl.org.rascalmpl.Cannot delete existing user preferences");
            }
        }
        this.additionalPrefs.addTo(prefs);
        prefs.setPreference((String)"org.rascalmpl.org.rascalmpl.webdriver_accept_untrusted_certs", (org.rascalmpl.org.rascalmpl.java.lang.Object)Boolean.valueOf((boolean)this.acceptUntrustedCerts));
        prefs.setPreference((String)"org.rascalmpl.org.rascalmpl.webdriver_assume_untrusted_issuer", (org.rascalmpl.org.rascalmpl.java.lang.Object)Boolean.valueOf((boolean)this.untrustedCertIssuer));
        org.rascalmpl.org.rascalmpl.java.lang.Object homePage = prefs.getPreference((String)"org.rascalmpl.org.rascalmpl.browser.startup.homepage");
        if (homePage instanceof String) {
            prefs.setPreference((String)"org.rascalmpl.org.rascalmpl.startup.homepage_welcome_url", (org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.");
        }
        if (!"org.rascalmpl.org.rascalmpl.about:blank".equals(prefs.getPreference((String)"org.rascalmpl.org.rascalmpl.browser.startup.homepage"))) {
            prefs.setPreference((String)"org.rascalmpl.org.rascalmpl.browser.startup.page", (org.rascalmpl.org.rascalmpl.java.lang.Object)Integer.valueOf((int)1));
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(userPrefs), Charset.defaultCharset());
            try {
                prefs.writeTo((Writer)writer);
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            writer.close();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)((Object)e));
        }
    }

    protected void deleteLockFiles(File profileDir) {
        File macAndLinuxLockFile = new File(profileDir, (String)"org.rascalmpl.org.rascalmpl..parentlock");
        File windowsLockFile = new File(profileDir, (String)"org.rascalmpl.org.rascalmpl.parent.lock");
        macAndLinuxLockFile.delete();
        windowsLockFile.delete();
    }

    public void deleteExtensionsCacheIfItExists(File profileDir) {
        File cacheFile = new File(profileDir, (String)"org.rascalmpl.org.rascalmpl.extensions.cache");
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
    }

    public boolean shouldLoadNoFocusLib() {
        return this.loadNoFocusLib;
    }

    public void setAlwaysLoadNoFocusLib(boolean loadNoFocusLib) {
        this.loadNoFocusLib = loadNoFocusLib;
    }

    public void setAcceptUntrustedCertificates(boolean acceptUntrustedSsl) {
        this.acceptUntrustedCerts = acceptUntrustedSsl;
    }

    public void setAssumeUntrustedCertificateIssuer(boolean untrustedIssuer) {
        this.untrustedCertIssuer = untrustedIssuer;
    }

    public void clean(File profileDir) {
        TemporaryFilesystem.getDefaultTmpFS().deleteTempDir(profileDir);
    }

    String toJson() throws IOException {
        File file = this.layoutOnDisk();
        try {
            String string = Zip.zip(file);
            return string;
        }
        finally {
            this.clean(file);
        }
    }

    public void cleanTemporaryModel() {
        this.clean(this.model);
    }

    public File layoutOnDisk() {
        try {
            File profileDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir((String)"org.rascalmpl.org.rascalmpl.anonymous", (String)"org.rascalmpl.org.rascalmpl.webdriver-profile");
            File userPrefs = new File(profileDir, (String)"org.rascalmpl.org.rascalmpl.user.js");
            this.copyModel(this.model, profileDir);
            this.installExtensions(profileDir);
            this.deleteLockFiles(profileDir);
            this.deleteExtensionsCacheIfItExists(profileDir);
            this.updateUserPrefs(userPrefs);
            return profileDir;
        }
        catch (IOException e) {
            throw new UnableToCreateProfileException((Throwable)((Object)e));
        }
    }

    protected void copyModel(File sourceDir, File profileDir) throws IOException {
        if (sourceDir == null || !sourceDir.exists()) {
            return;
        }
        FileHandler.copy(sourceDir, profileDir);
    }

    protected void installExtensions(File parentDir) throws IOException {
        File extensionsDir = new File(parentDir, (String)"org.rascalmpl.org.rascalmpl.extensions");
        for (Extension extension : this.extensions.values()) {
            extension.writeTo(extensionsDir);
        }
    }
}

