/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.firefox;

import org.rascalmpl.org.rascalmpl.java.io.BufferedReader;
import org.rascalmpl.org.rascalmpl.java.io.File;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.org.rascalmpl.java.nio.file.Files;
import org.rascalmpl.org.rascalmpl.java.nio.file.Path;
import org.rascalmpl.org.rascalmpl.java.text.MessageFormat;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.Platform;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.firefox.FirefoxProfile;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.io.FileHandler;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.io.TemporaryFilesystem;

public class ProfilesIni
extends Object {
    private final Map<String, File> profiles;

    public ProfilesIni() {
        File appData = this.locateAppDataDirectory(Platform.getCurrent());
        this.profiles = this.readProfiles(appData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, File> readProfiles(File appData) {
        HashMap toReturn = new HashMap();
        File profilesIni = new File(appData, (String)"org.rascalmpl.org.rascalmpl.profiles.ini");
        if (!profilesIni.exists()) {
            return toReturn;
        }
        boolean isRelative = true;
        String name = null;
        String path = null;
        BufferedReader reader = null;
        try {
            reader = Files.newBufferedReader((Path)profilesIni.toPath(), (Charset)Charset.defaultCharset());
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith((String)"org.rascalmpl.org.rascalmpl.[Profile")) {
                    File profile = this.newProfile(name, appData, path, isRelative);
                    if (profile != null) {
                        toReturn.put((Object)name, (Object)profile);
                    }
                    name = null;
                    path = null;
                } else if (line.startsWith((String)"org.rascalmpl.org.rascalmpl.Name=")) {
                    name = line.substring("org.rascalmpl.org.rascalmpl.Name=".length());
                } else if (line.startsWith((String)"org.rascalmpl.org.rascalmpl.IsRelative=")) {
                    isRelative = line.endsWith((String)"org.rascalmpl.org.rascalmpl.1");
                } else if (line.startsWith((String)"org.rascalmpl.org.rascalmpl.Path=")) {
                    path = line.substring("org.rascalmpl.org.rascalmpl.Path=".length());
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            try {
                throw new WebDriverException((org.rascalmpl.org.rascalmpl.java.lang.Throwable)((java.lang.Object)e));
            }
            catch (Throwable throwable) {
                try {
                    if (reader == null) throw throwable;
                    File profile = this.newProfile(name, appData, path, isRelative);
                    if (profile != null) {
                        toReturn.put(name, (Object)profile);
                    }
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (reader == null) return toReturn;
            File profile = this.newProfile(name, appData, path, isRelative);
            if (profile != null) {
                toReturn.put((Object)name, (Object)profile);
            }
            reader.close();
            return toReturn;
        }
        catch (IOException profile) {
            return toReturn;
        }
    }

    protected File newProfile(String name, File appData, String path, boolean isRelative) {
        if (name != null && path != null) {
            return isRelative ? new File(appData, path) : new File(path);
        }
        return null;
    }

    public FirefoxProfile getProfile(String profileName) {
        File profileDir = (File)this.profiles.get((Object)profileName);
        if (profileDir == null) {
            return null;
        }
        File tempDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir((String)"org.rascalmpl.org.rascalmpl.userprofile", (String)"org.rascalmpl.org.rascalmpl.copy");
        try {
            FileHandler.copy(profileDir, tempDir);
            File compreg = new File(tempDir, (String)"org.rascalmpl.org.rascalmpl.compreg.dat");
            if (compreg.exists() && !compreg.delete()) {
                throw new WebDriverException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.Cannot delete file from copy of profile \u0001"}, (String)profileName));
            }
        }
        catch (IOException e) {
            throw new WebDriverException((org.rascalmpl.org.rascalmpl.java.lang.Throwable)((java.lang.Object)e));
        }
        return new FirefoxProfile(tempDir);
    }

    protected File locateAppDataDirectory(Platform os) {
        File appData = os.is(Platform.WINDOWS) ? new File(MessageFormat.format((String)"org.rascalmpl.org.rascalmpl.{0}\\Mozilla\\Firefox", (Object[])new Object[]{System.getenv((String)"org.rascalmpl.org.rascalmpl.APPDATA")})) : (os.is(Platform.MAC) ? new File(MessageFormat.format((String)"org/rascalmpl/org/rascalmpl/{0}/Library/Application Support/Firefox", (Object[])new Object[]{System.getenv((String)"org.rascalmpl.org.rascalmpl.HOME")})) : new File(MessageFormat.format((String)"org/rascalmpl/org/rascalmpl/{0}/.mozilla/firefox", (Object[])new Object[]{System.getenv((String)"org.rascalmpl.org.rascalmpl.HOME")})));
        if (!appData.exists()) {
            return null;
        }
        if (!appData.isDirectory()) {
            throw new WebDriverException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.The discovered user firefox data directory (which normally contains the profiles) isn't a directory: \u0001"}, (String)appData.getAbsolutePath()));
        }
        return appData;
    }
}

