/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.ie;

import org.rascalmpl.org.rascalmpl.com.google.auto.service.AutoService;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.util.Optional;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.Capabilities;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.ImmutableCapabilities;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.Platform;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.SessionNotCreatedException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriver;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriverInfo;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.ie.InternetExplorerDriver;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.ie.InternetExplorerDriverService;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.ie.InternetExplorerOptions;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.Browser;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.service.DriverFinder;

@AutoService(value={WebDriverInfo.class})
public class InternetExplorerDriverInfo
extends Object
implements WebDriverInfo {
    private static final Logger LOG = Logger.getLogger((String)InternetExplorerDriverInfo.class.getName());

    @Override
    public String getDisplayName() {
        return "org.rascalmpl.org.rascalmpl.Internet Explorer";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities((String)"org.rascalmpl.org.rascalmpl.browserName", (Object)Browser.IE.browserName());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return Browser.IE.is(capabilities) || capabilities.getCapability((String)"org.rascalmpl.org.rascalmpl.se:ieOptions") != null;
    }

    @Override
    public boolean isSupportingCdp() {
        return false;
    }

    @Override
    public boolean isSupportingBiDi() {
        return false;
    }

    @Override
    public boolean isAvailable() {
        return Platform.getCurrent().is(Platform.WINDOWS) && new DriverFinder(InternetExplorerDriverService.createDefaultService(), this.getCanonicalCapabilities()).isAvailable();
    }

    @Override
    public boolean isPresent() {
        return Platform.getCurrent().is(Platform.WINDOWS) && new DriverFinder(InternetExplorerDriverService.createDefaultService(), this.getCanonicalCapabilities()).isPresent();
    }

    @Override
    public int getMaximumSimultaneousSessions() {
        return 1;
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of((Object)new InternetExplorerDriver(new InternetExplorerOptions().merge(capabilities)));
    }
}

