/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.ie;

import org.rascalmpl.org.rascalmpl.com.google.auto.service.AutoService;
import org.rascalmpl.org.rascalmpl.java.io.File;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.time.Duration;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.Capabilities;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.ie.InternetExplorerDriverLogLevel;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.ie.InternetExplorerOptions;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.Browser;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.service.DriverService;

public class InternetExplorerDriverService
extends DriverService {
    public static final String IE_DRIVER_NAME = "org.rascalmpl.org.rascalmpl.IEDriverServer";
    public static final String IE_DRIVER_EXE_PROPERTY = "org.rascalmpl.org.rascalmpl.webdriver.ie.driver";
    public static final String IE_DRIVER_LOGFILE_PROPERTY = "org.rascalmpl.org.rascalmpl.webdriver.ie.driver.logfile";
    public static final String IE_DRIVER_LOGLEVEL_PROPERTY = "org.rascalmpl.org.rascalmpl.webdriver.ie.driver.loglevel";
    public static final String IE_DRIVER_HOST_PROPERTY = "org.rascalmpl.org.rascalmpl.webdriver.ie.driver.host";
    public static final String IE_DRIVER_EXTRACT_PATH_PROPERTY = "org.rascalmpl.org.rascalmpl.webdriver.ie.driver.extractpath";
    public static final String IE_DRIVER_SILENT_PROPERTY = "org.rascalmpl.org.rascalmpl.webdriver.ie.driver.silent";

    public InternetExplorerDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, (List<String>)Collections.unmodifiableList((List)new ArrayList(args)), (Map<String, String>)Collections.unmodifiableMap((Map)new HashMap(environment)));
    }

    @Override
    public String getDriverName() {
        return "org.rascalmpl.org.rascalmpl.IEDriverServer";
    }

    @Override
    public String getDriverProperty() {
        return "org.rascalmpl.org.rascalmpl.webdriver.ie.driver";
    }

    @Override
    public Capabilities getDefaultDriverOptions() {
        return new InternetExplorerOptions();
    }

    public static InternetExplorerDriverService createDefaultService() {
        return (InternetExplorerDriverService)((Object)new Builder().build());
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<InternetExplorerDriverService, Builder> {
        private InternetExplorerDriverLogLevel logLevel;
        private String host = null;
        private File extractPath = null;
        private Boolean silent = null;

        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.IE.is(capabilities)) {
                ++score;
            }
            if (capabilities.getCapability((String)"org.rascalmpl.org.rascalmpl.se:ieOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withLogLevel(InternetExplorerDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withExtractPath(File extractPath) {
            this.extractPath = extractPath;
            return this;
        }

        public Builder withSilent(Boolean silent) {
            this.silent = silent;
            return this;
        }

        @Override
        protected void loadSystemProperties() {
            String silentProperty;
            String extractPathProperty;
            String hostProperty;
            String level;
            this.parseLogOutput((String)"org.rascalmpl.org.rascalmpl.webdriver.ie.driver.logfile");
            if (this.logLevel == null && (level = System.getProperty((String)"org.rascalmpl.org.rascalmpl.webdriver.ie.driver.loglevel")) != null) {
                this.logLevel = InternetExplorerDriverLogLevel.valueOf(level);
            }
            if (this.host == null && (hostProperty = System.getProperty((String)"org.rascalmpl.org.rascalmpl.webdriver.ie.driver.host")) != null) {
                this.host = hostProperty;
            }
            if (this.extractPath == null && (extractPathProperty = System.getProperty((String)"org.rascalmpl.org.rascalmpl.webdriver.ie.driver.extractpath")) != null) {
                this.extractPath = new File(extractPathProperty);
            }
            if (this.silent == null && (silentProperty = System.getProperty((String)"org.rascalmpl.org.rascalmpl.webdriver.ie.driver.silent")) != null) {
                this.silent = Boolean.valueOf((String)silentProperty);
            }
        }

        @Override
        protected List<String> createArgs() {
            ArrayList args = new ArrayList();
            args.add((org.rascalmpl.org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.org.rascalmpl.--port=%d", (org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{Integer.valueOf((int)this.getPort())}));
            if (this.logLevel != null) {
                args.add((org.rascalmpl.org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.org.rascalmpl.--log-level=%s", (org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{this.logLevel}));
            }
            if (this.host != null) {
                args.add((org.rascalmpl.org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.org.rascalmpl.--host=%s", (org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{this.host}));
            }
            if (this.extractPath != null) {
                args.add((org.rascalmpl.org.rascalmpl.java.lang.Object)String.format((String)"org.rascalmpl.org.rascalmpl.--extract-path=\"%s\"", (org.rascalmpl.org.rascalmpl.java.lang.Object[])new org.rascalmpl.org.rascalmpl.java.lang.Object[]{this.extractPath.getAbsolutePath()}));
            }
            if (Boolean.TRUE.equals((org.rascalmpl.org.rascalmpl.java.lang.Object)this.silent)) {
                args.add((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.--silent");
            }
            return Collections.unmodifiableList((List)args);
        }

        @Override
        protected InternetExplorerDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment) {
            try {
                return new InternetExplorerDriverService(exe, port, timeout, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)((Object)e));
            }
        }
    }
}

