/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions;

import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.StringBuilder;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Optional;
import org.rascalmpl.org.rascalmpl.java.util.UUID;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions.Encodable;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions.InputSource;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions.Interaction;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions.SourceType;

public class KeyInput
extends Object
implements InputSource,
Encodable {
    private final String name;

    public KeyInput(String name) {
        this.name = (String)Optional.ofNullable((Object)name).orElse((Object)UUID.randomUUID().toString());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SourceType getInputType() {
        return SourceType.KEY;
    }

    public Interaction createKeyDown(int codePoint) {
        return new TypingInteraction(this, (String)"org.rascalmpl.org.rascalmpl.keyDown", codePoint);
    }

    public Interaction createKeyUp(int codePoint) {
        return new TypingInteraction(this, (String)"org.rascalmpl.org.rascalmpl.keyUp", codePoint);
    }

    @Override
    public Map<String, Object> encode() {
        HashMap toReturn = new HashMap();
        toReturn.put((Object)"org.rascalmpl.org.rascalmpl.type", (Object)this.getInputType().getType());
        toReturn.put((Object)"org.rascalmpl.org.rascalmpl.id", (Object)this.name);
        return toReturn;
    }

    private static class TypingInteraction
    extends Interaction
    implements Encodable {
        private final String type;
        private final String value;

        TypingInteraction(InputSource source, String type, int codePoint) {
            super(source);
            this.type = type;
            this.value = new StringBuilder().appendCodePoint(codePoint).toString();
        }

        @Override
        public Map<String, Object> encode() {
            HashMap toReturn = new HashMap();
            toReturn.put((Object)"org.rascalmpl.org.rascalmpl.type", (Object)this.type);
            toReturn.put((Object)"org.rascalmpl.org.rascalmpl.value", (Object)this.value);
            return toReturn;
        }
    }
}

