/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions;

import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.time.Duration;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.LinkedList;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions.Encodable;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions.InputSource;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions.Interaction;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions.Pause;

public class Sequence
extends Object
implements Encodable {
    private final List<Encodable> actions = new LinkedList();
    private final InputSource device;

    public Sequence(InputSource device, int initialLength) {
        if (!(device instanceof Encodable)) {
            throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.Input device must implement Encodable: \u0001"}, (String)String.valueOf((Object)device)));
        }
        this.device = device;
        for (int i = 0; i < initialLength; ++i) {
            this.addAction(new Pause(device, Duration.ZERO));
        }
    }

    public Sequence addAction(Interaction action) {
        if (!action.isValidFor(this.device.getInputType())) {
            throw new IllegalArgumentException(String.format((String)"org.rascalmpl.org.rascalmpl.Interaction (%s) is for wrong kind of input device: %s ", (Object[])new Object[]{action.getClass(), this.device}));
        }
        if (!(action instanceof Encodable)) {
            throw new IllegalArgumentException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.Interaction must implement Encodable: \u0001"}, (String)String.valueOf((Object)action)));
        }
        this.actions.add((Object)((Encodable)((java.lang.Object)action)));
        return this;
    }

    @Override
    public Map<String, Object> encode() {
        HashMap toReturn = new HashMap(((Encodable)((java.lang.Object)this.device)).encode());
        LinkedList encodedActions = new LinkedList();
        for (Encodable action : this.actions) {
            HashMap encodedAction = new HashMap(action.encode());
            encodedActions.add((Object)encodedAction);
        }
        toReturn.put((Object)"org.rascalmpl.org.rascalmpl.actions", (Object)encodedActions);
        return toReturn;
    }

    public Map<String, Object> toJson() {
        return this.encode();
    }

    int size() {
        return this.actions.size();
    }
}

