/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions;

import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.Long;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.time.Duration;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Optional;
import org.rascalmpl.org.rascalmpl.java.util.UUID;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.Point;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebElement;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WrapsElement;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions.Encodable;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions.InputSource;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions.Interaction;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.interactions.SourceType;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.internal.Require;

public class WheelInput
extends Object
implements InputSource,
Encodable {
    private final String name;

    public WheelInput(String name) {
        this.name = (String)Optional.ofNullable((Object)name).orElse((Object)UUID.randomUUID().toString());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SourceType getInputType() {
        return SourceType.WHEEL;
    }

    public Interaction createScroll(int x, int y, int deltaX, int deltaY, Duration duration, ScrollOrigin origin) {
        return new ScrollInteraction(this, x, y, deltaX, deltaY, duration, origin);
    }

    public Interaction createScroll(Point start, int deltaX, int deltaY, Duration duration, ScrollOrigin origin) {
        return this.createScroll(start.x, start.y, deltaX, deltaY, duration, origin);
    }

    @Override
    public Map<String, Object> encode() {
        HashMap toReturn = new HashMap();
        toReturn.put((Object)"org.rascalmpl.org.rascalmpl.type", (Object)this.getInputType().getType());
        toReturn.put((Object)"org.rascalmpl.org.rascalmpl.id", (Object)this.name);
        return toReturn;
    }

    static class ScrollInteraction
    extends Interaction
    implements Encodable {
        private final int x;
        private final int y;
        private final int deltaX;
        private final int deltaY;
        private final Duration duration;
        private final ScrollOrigin origin;

        protected ScrollInteraction(InputSource source, int x, int y, int deltaX, int deltaY, Duration duration, ScrollOrigin origin) {
            super(source);
            this.x = x;
            this.y = y;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.duration = Require.nonNegative(duration);
            this.origin = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Origin of scroll", origin);
        }

        @Override
        public Map<String, Object> encode() {
            HashMap toReturn = new HashMap();
            toReturn.put((Object)"org.rascalmpl.org.rascalmpl.type", (Object)"org.rascalmpl.org.rascalmpl.scroll");
            toReturn.put((Object)"org.rascalmpl.org.rascalmpl.x", (Object)Integer.valueOf((int)this.x));
            toReturn.put((Object)"org.rascalmpl.org.rascalmpl.y", (Object)Integer.valueOf((int)this.y));
            toReturn.put((Object)"org.rascalmpl.org.rascalmpl.deltaX", (Object)Integer.valueOf((int)this.deltaX));
            toReturn.put((Object)"org.rascalmpl.org.rascalmpl.deltaY", (Object)Integer.valueOf((int)this.deltaY));
            toReturn.put((Object)"org.rascalmpl.org.rascalmpl.duration", (Object)Long.valueOf((long)this.duration.toMillis()));
            toReturn.put((Object)"org.rascalmpl.org.rascalmpl.origin", this.origin.asArg());
            return toReturn;
        }
    }

    public static final class ScrollOrigin
    extends Object {
        private final Object originObject;
        private int xOffset = 0;
        private int yOffset = 0;

        public Object asArg() {
            Object arg = this.originObject;
            while (arg instanceof WrapsElement) {
                arg = ((WrapsElement)arg).getWrappedElement();
            }
            return arg;
        }

        private ScrollOrigin(Object originObject, int xOffset, int yOffset) {
            this.originObject = originObject;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }

        public static ScrollOrigin fromViewport() {
            return new ScrollOrigin((Object)"org.rascalmpl.org.rascalmpl.viewport", 0, 0);
        }

        public static ScrollOrigin fromViewport(int xOffset, int yOffset) {
            return new ScrollOrigin((Object)"org.rascalmpl.org.rascalmpl.viewport", Require.nonNull((String)"org.rascalmpl.org.rascalmpl.xOffset", Integer.valueOf((int)xOffset)).intValue(), Require.nonNull((String)"org.rascalmpl.org.rascalmpl.yOffset", Integer.valueOf((int)yOffset)).intValue());
        }

        public static ScrollOrigin fromElement(WebElement element) {
            return new ScrollOrigin(Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Element", element), 0, 0);
        }

        public static ScrollOrigin fromElement(WebElement element, int xOffset, int yOffset) {
            return new ScrollOrigin(Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Element", element), Require.nonNull((String)"org.rascalmpl.org.rascalmpl.xOffset", Integer.valueOf((int)xOffset)).intValue(), Require.nonNull((String)"org.rascalmpl.org.rascalmpl.yOffset", Integer.valueOf((int)yOffset)).intValue());
        }

        public int getxOffset() {
            return this.xOffset;
        }

        public int getyOffset() {
            return this.yOffset;
        }
    }
}

