/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.io;

import org.rascalmpl.org.rascalmpl.java.io.File;
import org.rascalmpl.org.rascalmpl.java.io.FileOutputStream;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.InputStream;
import org.rascalmpl.org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.CallSite;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.nio.file.Files;
import org.rascalmpl.org.rascalmpl.java.nio.file.Path;
import org.rascalmpl.org.rascalmpl.java.util.Arrays;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.io.Zip;

public class FileHandler
extends Object {
    public static void copyResource(File outputDir, Class<?> forClassLoader, String ... names) throws IOException {
        for (String name : names) {
            InputStream is = FileHandler.locateResource(forClassLoader, name);
            try {
                Zip.unzipFile(outputDir, is, name);
                if (is == null) continue;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
    }

    private static InputStream locateResource(Class<?> forClassLoader, String name) throws IOException {
        CallSite arch = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org/rascalmpl/org/rascalmpl/\u0001/"}, (String)((String)Objects.requireNonNull((Object)System.getProperty((String)"org.rascalmpl.org.rascalmpl.os.arch"))).toLowerCase());
        List alternatives = Arrays.asList((Object[])new String[]{name, StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org/rascalmpl/org/rascalmpl//\u0001"}, (String)name), StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.\u0001\u0001"}, (String)arch, (String)name), StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org/rascalmpl/org/rascalmpl//\u0001\u0001"}, (String)arch, (String)name)});
        if (System.getProperty((String)"org.rascalmpl.org.rascalmpl.os.name").toLowerCase().contains((CharSequence)"org.rascalmpl.org.rascalmpl.mac")) {
            alternatives.add((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org/rascalmpl/org/rascalmpl/mac/\u0001"}, (String)name));
            alternatives.add((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org/rascalmpl/org/rascalmpl//mac/\u0001"}, (String)name));
        }
        for (String possibility : alternatives) {
            InputStream stream = FileHandler.class.getResourceAsStream(possibility);
            if (stream != null) {
                return stream;
            }
            stream = forClassLoader.getResourceAsStream(possibility);
            if (stream == null) continue;
            return stream;
        }
        throw new IOException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.Unable to locate: \u0001"}, (String)name));
    }

    public static boolean createDir(File dir) {
        if ((dir.exists() || dir.mkdirs()) && dir.canWrite()) {
            return true;
        }
        if (dir.exists()) {
            FileHandler.makeWritable(dir);
            return dir.canWrite();
        }
        return FileHandler.createDir(dir.getParentFile());
    }

    public static boolean makeWritable(File file) {
        return file.canWrite() || file.setWritable(true);
    }

    public static boolean isZipped(String fileName) {
        return fileName.endsWith((String)"org.rascalmpl.org.rascalmpl..zip") || fileName.endsWith((String)"org.rascalmpl.org.rascalmpl..xpi");
    }

    public static boolean delete(File toDelete) {
        File[] children;
        boolean deleted = true;
        if (toDelete.isDirectory() && (children = toDelete.listFiles()) != null) {
            for (File child : children) {
                deleted &= child.canWrite() && FileHandler.delete(child);
            }
        }
        return deleted && toDelete.canWrite() && toDelete.delete();
    }

    public static void copy(File from, File to) throws IOException {
        if (!from.exists()) {
            return;
        }
        if (from.isDirectory()) {
            FileHandler.copyDir(from, to);
        } else {
            FileHandler.copyFile(from, to);
        }
    }

    private static void copyDir(File from, File to) throws IOException {
        FileHandler.createDir(to);
        String[] children = from.list();
        if (children == null) {
            throw new IOException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.Could not copy directory \u0001"}, (String)from.getPath()));
        }
        for (String child : children) {
            if ("org.rascalmpl.org.rascalmpl..parentlock".equals((Object)child) || "org.rascalmpl.org.rascalmpl.parent.lock".equals((Object)child)) continue;
            FileHandler.copy(new File(from, child), new File(to, child));
        }
    }

    private static void copyFile(File from, File to) throws IOException {
        FileOutputStream out = new FileOutputStream(to);
        try {
            long copied = Files.copy((Path)from.toPath(), (OutputStream)out);
            long length = from.length();
            if (copied != length) {
                throw new IOException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.Could not transfer all bytes from \u0001 to \u0001"}, (String)String.valueOf((Object)from), (String)String.valueOf((Object)to)));
            }
        }
        catch (Throwable throwable) {
            try {
                out.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        out.close();
    }
}

