/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.io;

import org.rascalmpl.org.rascalmpl.java.io.BufferedOutputStream;
import org.rascalmpl.org.rascalmpl.java.io.ByteArrayInputStream;
import org.rascalmpl.org.rascalmpl.java.io.ByteArrayOutputStream;
import org.rascalmpl.org.rascalmpl.java.io.File;
import org.rascalmpl.org.rascalmpl.java.io.FileInputStream;
import org.rascalmpl.org.rascalmpl.java.io.FileOutputStream;
import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.InputStream;
import org.rascalmpl.org.rascalmpl.java.io.OutputStream;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.util.Base64;
import org.rascalmpl.org.rascalmpl.java.util.zip.ZipEntry;
import org.rascalmpl.org.rascalmpl.java.util.zip.ZipInputStream;
import org.rascalmpl.org.rascalmpl.java.util.zip.ZipOutputStream;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.io.FileHandler;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.io.TemporaryFilesystem;

public class Zip
extends Object {
    private static final int BUF_SIZE = 16384;

    public static String zip(File input) throws IOException {
        String string;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ZipOutputStream zos;
            block9: {
                zos = new ZipOutputStream((OutputStream)bos);
                try {
                    if (input.isDirectory()) {
                        Zip.addToZip(input.getAbsolutePath(), zos, input);
                        break block9;
                    }
                    Zip.addToZip(input.getParentFile().getAbsolutePath(), zos, input);
                }
                catch (Throwable throwable) {
                    try {
                        zos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            zos.close();
            string = Base64.getEncoder().encodeToString(bos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                bos.close();
            }
            catch (Throwable throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        bos.close();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addToZip(String basePath, ZipOutputStream zos, File toAdd) throws IOException {
        if (toAdd.isDirectory()) {
            File[] files = toAdd.listFiles();
            if (files == null) return;
            File[] fileArray = files;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                Zip.addToZip(basePath, zos, file);
                ++n2;
            }
            return;
        }
        FileInputStream fis = new FileInputStream(toAdd);
        try {
            int len;
            String name = toAdd.getAbsolutePath().substring(basePath.length() + 1);
            ZipEntry entry = new ZipEntry(name.replace('\\', '/'));
            zos.putNextEntry(entry);
            byte[] buffer = new byte[4096];
            while ((len = fis.read(buffer)) != -1) {
                zos.write(buffer, 0, len);
            }
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            try {
                fis.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        fis.close();
    }

    public static File unzipToTempDir(String source, String prefix, String suffix) throws IOException {
        File output = TemporaryFilesystem.getDefaultTmpFS().createTempDir(prefix, suffix);
        Zip.unzip(source, output);
        return output;
    }

    public static void unzip(String source, File outputDir) throws IOException {
        byte[] bytes = Base64.getMimeDecoder().decode(source);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        try {
            Zip.unzip((InputStream)bis, outputDir);
        }
        catch (Throwable throwable) {
            try {
                bis.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        bis.close();
    }

    public static File unzipToTempDir(InputStream source, String prefix, String suffix) throws IOException {
        File output = TemporaryFilesystem.getDefaultTmpFS().createTempDir(prefix, suffix);
        Zip.unzip(source, output);
        return output;
    }

    public static void unzip(InputStream source, File outputDir) throws IOException {
        ZipInputStream zis = new ZipInputStream(source);
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    FileHandler.createDir(file);
                    continue;
                }
                Zip.unzipFile(outputDir, (InputStream)zis, entry.getName());
            }
        }
        catch (Throwable throwable) {
            try {
                zis.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        zis.close();
    }

    public static void unzipFile(File output, InputStream zipStream, String name) throws IOException {
        String canonicalDestinationDirPath = output.getCanonicalPath();
        File toWrite = new File(output, name);
        String canonicalDestinationFile = toWrite.getCanonicalPath();
        if (!canonicalDestinationFile.startsWith((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.\u0001\u0001"}, (String)canonicalDestinationDirPath, (String)File.separator))) {
            throw new IOException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.Entry is outside of the target dir: \u0001"}, (String)name));
        }
        if (!FileHandler.createDir(toWrite.getParentFile())) {
            throw new IOException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.Cannot create parent directory for: \u0001"}, (String)name));
        }
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)new FileOutputStream(toWrite), 16384);
        try {
            int read;
            byte[] buffer = new byte[16384];
            while ((read = zipStream.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (Throwable throwable) {
            try {
                out.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        out.close();
    }
}

