/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.net;

import org.rascalmpl.org.rascalmpl.java.io.BufferedReader;
import org.rascalmpl.org.rascalmpl.java.io.InputStreamReader;
import org.rascalmpl.org.rascalmpl.java.io.Reader;
import org.rascalmpl.org.rascalmpl.java.lang.InterruptedException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.Process;
import org.rascalmpl.org.rascalmpl.java.lang.Runtime;
import org.rascalmpl.org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.lang.Thread;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.net.InetAddress;
import org.rascalmpl.org.rascalmpl.java.net.NetworkInterface;
import org.rascalmpl.org.rascalmpl.java.nio.charset.Charset;
import org.rascalmpl.org.rascalmpl.java.util.Enumeration;
import org.rascalmpl.org.rascalmpl.java.util.concurrent.TimeUnit;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.Platform;

public class HostIdentifier
extends Object {
    private static final Logger LOG = Logger.getLogger((String)HostIdentifier.class.getName());
    private static volatile String hostName;
    private static volatile String hostAddress;

    private static String resolveHostName() {
        java.lang.Object host;
        block17: {
            host = System.getenv((String)"org.rascalmpl.org.rascalmpl.HOSTNAME");
            if (host == null) {
                host = System.getenv((String)"org.rascalmpl.org.rascalmpl.COMPUTERNAME");
            }
            if (host == null && Platform.getCurrent().is(Platform.MAC)) {
                try {
                    Process process = Runtime.getRuntime().exec((String)"org.rascalmpl.org.rascalmpl.hostname");
                    if (!process.waitFor(2L, TimeUnit.SECONDS)) {
                        process.destroyForcibly();
                        process.waitFor(2L, TimeUnit.SECONDS);
                    }
                    if (process.exitValue() != 0) break block17;
                    InputStreamReader isr = new InputStreamReader(process.getInputStream(), Charset.defaultCharset());
                    try {
                        BufferedReader reader = new BufferedReader((Reader)isr);
                        try {
                            host = reader.readLine();
                        }
                        catch (Throwable throwable) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        try {
                            isr.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    isr.close();
                }
                catch (InterruptedException e) {
                    LOG.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Failed to resolve host name", (Throwable)((java.lang.Object)e));
                    Thread.currentThread().interrupt();
                    throw new RuntimeException((Throwable)((java.lang.Object)e));
                }
                catch (Throwable e) {
                    LOG.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Failed to resolve host name", e);
                }
            }
        }
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable e) {
                host = "org.rascalmpl.org.rascalmpl.Unknown";
                LOG.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Failed to resolve host name", e);
            }
        }
        return host;
    }

    private static String resolveHostAddress() {
        java.lang.Object address = null;
        if (Platform.getCurrent().is(Platform.MAC)) {
            try {
                Enumeration addresses;
                NetworkInterface en0 = NetworkInterface.getByName((String)"org.rascalmpl.org.rascalmpl.en0");
                if (en0 != null && (addresses = en0.getInetAddresses()).hasMoreElements()) {
                    address = ((InetAddress)addresses.nextElement()).getHostAddress();
                }
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Failed to resolve host address", e);
            }
        }
        if (address == null) {
            try {
                address = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable e) {
                address = "org.rascalmpl.org.rascalmpl.Unknown";
                LOG.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Failed to resolve host address", e);
            }
        }
        return address;
    }

    public static synchronized String getHostName() {
        if (hostName == null) {
            hostName = HostIdentifier.resolveHostName();
        }
        return hostName;
    }

    public static synchronized String getHostAddress() {
        if (hostAddress == null) {
            hostAddress = HostIdentifier.resolveHostAddress();
        }
        return hostAddress;
    }
}

