/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.net;

import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.UncheckedIOException;
import org.rascalmpl.org.rascalmpl.java.io.UnsupportedEncodingException;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.net.MalformedURLException;
import org.rascalmpl.org.rascalmpl.java.net.URI;
import org.rascalmpl.org.rascalmpl.java.net.URISyntaxException;
import org.rascalmpl.org.rascalmpl.java.net.URL;
import org.rascalmpl.org.rascalmpl.java.net.URLEncoder;
import org.rascalmpl.org.rascalmpl.java.util.regex.Pattern;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.internal.Require;

public class Urls
extends Object {
    private Urls() {
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode((String)value, (String)"org.rascalmpl.org.rascalmpl.UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException((IOException)((java.lang.Object)e));
        }
    }

    public static URL fromUri(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException((IOException)((java.lang.Object)e));
        }
    }

    public static URI from(String rawUri) {
        Require.nonNull((String)"org.rascalmpl.org.rascalmpl.URL to convert", rawUri);
        try {
            int colonIndex = rawUri.indexOf(58);
            int slashIndex = rawUri.indexOf(47);
            if (slashIndex == -1 && colonIndex == -1) {
                return Urls.createHttpUri(rawUri);
            }
            if (colonIndex != -1) {
                if (colonIndex == 0) {
                    return Urls.createHttpUri(rawUri);
                }
                if (Pattern.matches((String)"org.rascalmpl.org.rascalmpl.\\d+", (CharSequence)rawUri.substring(0, colonIndex))) {
                    return Urls.createHttpUri(rawUri);
                }
            }
            return new URI(rawUri);
        }
        catch (URISyntaxException e) {
            throw new UncheckedIOException(new IOException((Throwable)((java.lang.Object)e)));
        }
    }

    private static URI createHttpUri(String rawHost) {
        int slashIndex = rawHost.indexOf(47);
        String host = slashIndex == -1 ? rawHost : rawHost.substring(0, slashIndex);
        String path = slashIndex == -1 ? null : rawHost.substring(slashIndex);
        try {
            return new URI((String)"org.rascalmpl.org.rascalmpl.http", host, path, null);
        }
        catch (URISyntaxException e) {
            throw new UncheckedIOException(new IOException((Throwable)((java.lang.Object)e)));
        }
    }
}

