/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.print;

import org.rascalmpl.org.rascalmpl.java.lang.Boolean;
import org.rascalmpl.org.rascalmpl.java.lang.Double;
import org.rascalmpl.org.rascalmpl.java.lang.Enum;
import org.rascalmpl.org.rascalmpl.java.lang.IllegalArgumentException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.System;
import org.rascalmpl.org.rascalmpl.java.util.HashMap;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.internal.Require;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.print.PageMargin;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.print.PageSize;

public class PrintOptions
extends Object {
    private Orientation orientation = Orientation.PORTRAIT;
    private double scale = 1.0;
    private boolean background = false;
    private boolean shrinkToFit = true;
    private PageSize pageSize = new PageSize();
    private PageMargin pageMargin = new PageMargin();
    private String[] pageRanges;

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.orientation", orientation);
    }

    public String[] getPageRanges() {
        return this.pageRanges;
    }

    public void setPageRanges(String firstRange, String ... ranges) {
        Require.nonNull((String)"org.rascalmpl.org.rascalmpl.pageRanges", firstRange);
        this.pageRanges = new String[ranges.length + 1];
        this.pageRanges[0] = firstRange;
        if (ranges.length > 0) {
            System.arraycopy((Object)ranges, (int)0, (Object)this.pageRanges, (int)1, (int)(ranges.length - 1));
        }
    }

    public void setPageRanges(List<String> ranges) {
        this.pageRanges = new String[ranges.size()];
        this.pageRanges = (String[])ranges.toArray((Object[])this.pageRanges);
    }

    public void setBackground(boolean background) {
        this.background = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.background", Boolean.valueOf((boolean)background)).booleanValue();
    }

    public boolean getBackground() {
        return this.background;
    }

    public void setScale(double scale) {
        if (scale < 0.1 || scale > 2.0) {
            throw new IllegalArgumentException((String)"org.rascalmpl.org.rascalmpl.Scale value should be between 0.1 and 2");
        }
        this.scale = scale;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean getShrinkToFit() {
        return this.shrinkToFit;
    }

    public void setShrinkToFit(boolean value) {
        this.shrinkToFit = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.value", Boolean.valueOf((boolean)value)).booleanValue();
    }

    public void setPageSize(PageSize pageSize) {
        this.pageSize = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.pageSize", pageSize);
    }

    public void setPageMargin(PageMargin margin) {
        this.pageMargin = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.margin", margin);
    }

    public PageSize getPageSize() {
        return this.pageSize;
    }

    public PageMargin getPageMargin() {
        return this.pageMargin;
    }

    public Map<String, Object> toMap() {
        HashMap options = new HashMap(7);
        options.put((Object)"org.rascalmpl.org.rascalmpl.page", this.getPageSize().toMap());
        options.put((Object)"org.rascalmpl.org.rascalmpl.orientation", (Object)this.getOrientation().toString());
        options.put((Object)"org.rascalmpl.org.rascalmpl.scale", (Object)Double.valueOf((double)this.getScale()));
        options.put((Object)"org.rascalmpl.org.rascalmpl.shrinkToFit", (Object)Boolean.valueOf((boolean)this.getShrinkToFit()));
        options.put((Object)"org.rascalmpl.org.rascalmpl.background", (Object)Boolean.valueOf((boolean)this.getBackground()));
        String[] effectivePageRanges = this.getPageRanges();
        if (effectivePageRanges != null) {
            options.put((Object)"org.rascalmpl.org.rascalmpl.pageRanges", (Object)effectivePageRanges);
        }
        options.put((Object)"org.rascalmpl.org.rascalmpl.margin", this.getPageMargin().toMap());
        return options;
    }

    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation PORTRAIT = new Orientation((String)"org.rascalmpl.org.rascalmpl.PORTRAIT", 0, (String)"org.rascalmpl.org.rascalmpl.portrait");
        public static final /* enum */ Orientation LANDSCAPE = new Orientation((String)"org.rascalmpl.org.rascalmpl.LANDSCAPE", 1, (String)"org.rascalmpl.org.rascalmpl.landscape");
        private final String serialFormat;
        private static final /* synthetic */ Orientation[] $VALUES;

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        public static Orientation valueOf(String name) {
            return (Orientation)Enum.valueOf(Orientation.class, (String)name);
        }

        private Orientation(String serialFormat) {
            super((String)string, n);
            this.serialFormat = serialFormat;
        }

        public String toString() {
            return this.serialFormat;
        }

        private static /* synthetic */ Orientation[] $values() {
            return new Orientation[]{PORTRAIT, LANDSCAPE};
        }

        static {
            $VALUES = Orientation.$values();
        }
    }
}

