/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote;

import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.Class;
import org.rascalmpl.org.rascalmpl.java.lang.ClassCastException;
import org.rascalmpl.org.rascalmpl.java.lang.Error;
import org.rascalmpl.org.rascalmpl.java.lang.Integer;
import org.rascalmpl.org.rascalmpl.java.lang.Number;
import org.rascalmpl.org.rascalmpl.java.lang.NumberFormatException;
import org.rascalmpl.org.rascalmpl.java.lang.OutOfMemoryError;
import org.rascalmpl.org.rascalmpl.java.lang.ReflectiveOperationException;
import org.rascalmpl.org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.org.rascalmpl.java.lang.StackTraceElement;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.lang.reflect.Constructor;
import org.rascalmpl.org.rascalmpl.java.math.BigDecimal;
import org.rascalmpl.org.rascalmpl.java.math.RoundingMode;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Optional;
import org.rascalmpl.org.rascalmpl.java.util.function.Function;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.UnhandledAlertException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.ErrorCodes;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.Response;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.ScreenshotException;

public class ErrorHandler
extends org.rascalmpl.org.rascalmpl.java.lang.Object {
    private static final String MESSAGE = "org.rascalmpl.org.rascalmpl.message";
    private static final String SCREEN_SHOT = "org.rascalmpl.org.rascalmpl.screen";
    private static final String CLASS = "org.rascalmpl.org.rascalmpl.class";
    private static final String STACK_TRACE = "org.rascalmpl.org.rascalmpl.stackTrace";
    private static final String LINE_NUMBER = "org.rascalmpl.org.rascalmpl.lineNumber";
    private static final String METHOD_NAME = "org.rascalmpl.org.rascalmpl.methodName";
    private static final String CLASS_NAME = "org.rascalmpl.org.rascalmpl.className";
    private static final String FILE_NAME = "org.rascalmpl.org.rascalmpl.fileName";
    private static final String UNKNOWN_CLASS = "org.rascalmpl.org.rascalmpl.<anonymous class>";
    private static final String UNKNOWN_METHOD = "org.rascalmpl.org.rascalmpl.<anonymous method>";
    private static final String UNKNOWN_FILE = null;
    private final ErrorCodes errorCodes;
    private boolean includeServerErrors;

    public ErrorHandler() {
        this(true);
    }

    public ErrorHandler(boolean includeServerErrors) {
        this.includeServerErrors = includeServerErrors;
        this.errorCodes = new ErrorCodes();
    }

    public ErrorHandler(ErrorCodes codes, boolean includeServerErrors) {
        this.includeServerErrors = includeServerErrors;
        this.errorCodes = codes;
    }

    public boolean isIncludeServerErrors() {
        return this.includeServerErrors;
    }

    public void setIncludeServerErrors(boolean includeServerErrors) {
        this.includeServerErrors = includeServerErrors;
    }

    public Response throwIfResponseFailed(Response response, long duration) throws RuntimeException {
        if ("org.rascalmpl.org.rascalmpl.success".equals((org.rascalmpl.org.rascalmpl.java.lang.Object)response.getState())) {
            return response;
        }
        if (response.getValue() instanceof Throwable) {
            Throwable throwable = (Throwable)response.getValue();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        Class<? extends WebDriverException> outerErrorType = this.errorCodes.getExceptionType(response.getStatus().intValue());
        org.rascalmpl.org.rascalmpl.java.lang.Object value = response.getValue();
        String message = null;
        Object cause = null;
        if (value instanceof Map) {
            Map rawErrorData = (Map)value;
            if (!rawErrorData.containsKey((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.message") && rawErrorData.containsKey((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.value")) {
                try {
                    rawErrorData = (Map)rawErrorData.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.value");
                }
                catch (ClassCastException cce) {
                    message = String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)cce);
                }
            }
            try {
                message = (String)rawErrorData.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.message");
            }
            catch (ClassCastException e) {
                message = String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)e);
            }
            Throwable serverError = this.rebuildServerError((Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object>)rawErrorData, response.getStatus().intValue());
            if (serverError == null) {
                if (this.includeServerErrors) {
                    message = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.\u0001 (WARNING: The server did not provide any stacktrace information)"}, (String)message);
                }
            } else if (!this.includeServerErrors) {
                message = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.\u0001 (WARNING: The client has suppressed server-side stacktraces)"}, (String)message);
            } else {
                cause = serverError;
                if (cause.getStackTrace() == null || cause.getStackTrace().length == 0) {
                    message = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.\u0001 (WARNING: The server did not provide any stacktrace information)"}, (String)message);
                }
            }
            if (rawErrorData.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.screen") != null) {
                cause = new ScreenshotException(String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)rawErrorData.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.screen")), (Throwable)((Object)cause));
            }
        } else if (value != null) {
            message = String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)value);
        }
        String duration1 = this.duration(duration);
        if (message != null && !message.contains((CharSequence)duration1)) {
            message = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.\u0001\u0001"}, (String)message, (String)duration1);
        }
        WebDriverException toThrow = null;
        if (outerErrorType.equals(UnhandledAlertException.class) && value instanceof Map) {
            toThrow = this.createUnhandledAlertException(value);
        }
        if (toThrow == null) {
            toThrow = this.createThrowable(outerErrorType, new Class[]{String.class, Throwable.class, Integer.class}, new org.rascalmpl.org.rascalmpl.java.lang.Object[]{message, cause, response.getStatus()});
        }
        if (toThrow == null) {
            toThrow = this.createThrowable(outerErrorType, new Class[]{String.class, Throwable.class}, new org.rascalmpl.org.rascalmpl.java.lang.Object[]{message, cause});
        }
        if (toThrow == null) {
            toThrow = this.createThrowable(outerErrorType, new Class[]{String.class}, new org.rascalmpl.org.rascalmpl.java.lang.Object[]{message});
        }
        if (toThrow == null) {
            toThrow = new WebDriverException(message, (Throwable)((Object)cause));
        }
        throw toThrow;
    }

    private UnhandledAlertException createUnhandledAlertException(org.rascalmpl.org.rascalmpl.java.lang.Object value) {
        Map rawErrorData = (Map)value;
        if (rawErrorData.containsKey((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.alert") || rawErrorData.containsKey((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.alertText")) {
            Map alert;
            org.rascalmpl.org.rascalmpl.java.lang.Object alertText = rawErrorData.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.alertText");
            if (alertText == null && (alert = (Map)rawErrorData.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.alert")) != null) {
                alertText = alert.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.text");
            }
            return this.createThrowable((Class)UnhandledAlertException.class, (Class<?>[])new Class[]{String.class, String.class}, new org.rascalmpl.org.rascalmpl.java.lang.Object[]{rawErrorData.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.message"), alertText});
        }
        return null;
    }

    private String duration(long duration) {
        java.lang.String prefix = "org.rascalmpl.org.rascalmpl.\nCommand duration or timeout: ";
        if (duration < 1000L) {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.\u0001\u0001 milliseconds"}, (String)prefix, (long)duration);
        }
        return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.\u0001\u0001 seconds"}, (String)prefix, (String)String.valueOf((org.rascalmpl.org.rascalmpl.java.lang.Object)new BigDecimal(duration).divide(new BigDecimal(1000)).setScale(2, RoundingMode.HALF_UP)));
    }

    private <T extends Throwable> T createThrowable(Class<T> clazz, Class<?>[] parameterTypes, org.rascalmpl.org.rascalmpl.java.lang.Object[] parameters) {
        try {
            Constructor constructor = clazz.getConstructor(parameterTypes);
            return (T)((Object)((Throwable)constructor.newInstance(parameters)));
        }
        catch (OutOfMemoryError | ReflectiveOperationException throwable) {
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private Throwable rebuildServerError(Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object> rawErrorData, int responseStatus) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IllegalStateException: Dynamic invoke Expected org.rascalmpl.org.rascalmpl.java.lang.invoke.MethodType, got (Lorg/rascalmpl/org/rascalmpl/java/lang/Object;)Lorg/rascalmpl/org/rascalmpl/java/lang/Object;
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamicMetaFactoryArgs(Op02WithProcessedDataAndRefs.java:711)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:432)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ StackTraceElement[] lambda$rebuildServerError$1(int x$0) {
        return new StackTraceElement[x$0];
    }

    private static /* synthetic */ StackTraceElement lambda$rebuildServerError$0(Map entry) {
        return new FrameInfoToStackFrame().apply((Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object>)entry);
    }

    public static class UnknownServerException
    extends WebDriverException {
        private UnknownServerException(String s2) {
            super(s2);
        }
    }

    private static class FrameInfoToStackFrame
    extends org.rascalmpl.org.rascalmpl.java.lang.Object
    implements Function<Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object>, StackTraceElement> {
        private FrameInfoToStackFrame() {
        }

        public StackTraceElement apply(Map<String, org.rascalmpl.org.rascalmpl.java.lang.Object> frameInfo) {
            if (frameInfo == null) {
                return null;
            }
            Optional maybeLineNumberInteger = Optional.empty();
            org.rascalmpl.org.rascalmpl.java.lang.Object lineNumberObject = frameInfo.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.lineNumber");
            if (lineNumberObject instanceof Number) {
                maybeLineNumberInteger = Optional.of((org.rascalmpl.org.rascalmpl.java.lang.Object)((Number)lineNumberObject));
            } else if (lineNumberObject != null) {
                try {
                    maybeLineNumberInteger = Optional.of((org.rascalmpl.org.rascalmpl.java.lang.Object)Integer.valueOf((int)Integer.parseInt((String)lineNumberObject.toString())));
                }
                catch (NumberFormatException e) {
                    maybeLineNumberInteger = Optional.empty();
                }
            }
            int lineNumber = ((Number)maybeLineNumberInteger.orElse((org.rascalmpl.org.rascalmpl.java.lang.Object)Integer.valueOf((int)-1))).intValue();
            java.lang.String className = frameInfo.containsKey((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.className") ? FrameInfoToStackFrame.toStringOrNull(frameInfo.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.className")) : "org.rascalmpl.org.rascalmpl.<anonymous class>";
            java.lang.String methodName = frameInfo.containsKey((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.methodName") ? FrameInfoToStackFrame.toStringOrNull(frameInfo.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.methodName")) : "org.rascalmpl.org.rascalmpl.<anonymous method>";
            String fileName = frameInfo.containsKey((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.fileName") ? FrameInfoToStackFrame.toStringOrNull(frameInfo.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.fileName")) : UNKNOWN_FILE;
            return new StackTraceElement((String)className, (String)methodName, fileName, lineNumber);
        }

        private static String toStringOrNull(org.rascalmpl.org.rascalmpl.java.lang.Object o) {
            return o == null ? null : o.toString();
        }
    }
}

