/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote;

import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.UnsupportedOperationException;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.net.URL;
import org.rascalmpl.org.rascalmpl.java.util.Collections;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.NoSuchSessionException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.SessionNotCreatedException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.UnsupportedCommandException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.internal.Require;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.logging.LocalLogs;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.logging.LogEntry;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.logging.NeedsLocalLogs;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.logging.profiler.HttpProfilerLogEntry;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.Command;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.CommandCodec;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.CommandExecutor;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.CommandInfo;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.Dialect;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.HttpSessionId;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.ProtocolHandshake;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.Response;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.ResponseCodec;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.ClientConfig;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.HttpClient;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.HttpHandler;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.HttpRequest;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.HttpResponse;

public class HttpCommandExecutor
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements CommandExecutor,
NeedsLocalLogs {
    private final URL remoteServer;
    private final HttpClient client;
    private final HttpClient.Factory httpClientFactory;
    private final Map<String, CommandInfo> additionalCommands;
    private CommandCodec<HttpRequest> commandCodec;
    private ResponseCodec<HttpResponse> responseCodec;
    private LocalLogs logs = LocalLogs.getNullLogger();

    public static HttpClient.Factory getDefaultClientFactory() {
        return DefaultClientFactoryHolder.defaultClientFactory;
    }

    public HttpCommandExecutor(URL addressOfRemoteServer) {
        this((Map<String, CommandInfo>)Collections.emptyMap(), Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Server URL", addressOfRemoteServer));
    }

    public HttpCommandExecutor(ClientConfig config) {
        this((Map<String, CommandInfo>)Collections.emptyMap(), Require.nonNull((String)"org.rascalmpl.org.rascalmpl.HTTP client configuration", config), HttpCommandExecutor.getDefaultClientFactory());
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        this(Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Additional commands", additionalCommands), Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Server URL", addressOfRemoteServer), HttpCommandExecutor.getDefaultClientFactory());
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, ClientConfig config) {
        this(additionalCommands, config.baseUrl(Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Server URL", addressOfRemoteServer)), HttpCommandExecutor.getDefaultClientFactory());
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, ClientConfig.defaultConfig().baseUrl(Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Server URL", addressOfRemoteServer)), httpClientFactory);
    }

    public HttpCommandExecutor(Map<String, CommandInfo> additionalCommands, ClientConfig config, HttpClient.Factory httpClientFactory) {
        this.remoteServer = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.HTTP client configuration", config).baseUrl();
        this.additionalCommands = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Additional commands", additionalCommands);
        this.httpClientFactory = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.HTTP client factory", httpClientFactory);
        this.client = this.httpClientFactory.createClient(config);
    }

    protected void defineCommand(String commandName, CommandInfo info) {
        Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Command name", commandName);
        Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Command info", info);
        this.commandCodec.defineCommand(commandName, info.getMethod(), info.getUrl());
    }

    @Override
    public void setLocalLogs(LocalLogs logs) {
        this.logs = logs;
    }

    private void log(String logType, LogEntry entry) {
        this.logs.addEntry(logType, entry);
    }

    public URL getAddressOfRemoteServer() {
        return this.remoteServer;
    }

    @Override
    public Response execute(Command command) throws IOException {
        if (command.getSessionId() == null) {
            if ("org.rascalmpl.org.rascalmpl.quit".equals((org.rascalmpl.org.rascalmpl.java.lang.Object)command.getName())) {
                return new Response();
            }
            if (!"org.rascalmpl.org.rascalmpl.newSession".equals((org.rascalmpl.org.rascalmpl.java.lang.Object)command.getName())) {
                throw new NoSuchSessionException((String)"org.rascalmpl.org.rascalmpl.Session ID is null. Using WebDriver after calling quit()?");
            }
        }
        if ("org.rascalmpl.org.rascalmpl.newSession".equals((org.rascalmpl.org.rascalmpl.java.lang.Object)command.getName())) {
            if (this.commandCodec != null) {
                throw new SessionNotCreatedException((String)"org.rascalmpl.org.rascalmpl.Session already exists");
            }
            ProtocolHandshake handshake = new ProtocolHandshake();
            this.log((String)"org.rascalmpl.org.rascalmpl.profiler", new HttpProfilerLogEntry(command.getName(), true));
            ProtocolHandshake.Result result = handshake.createSession((HttpHandler)this.client, command);
            Dialect dialect = result.getDialect();
            this.commandCodec = dialect.getCommandCodec();
            for (Map.Entry entry : this.additionalCommands.entrySet()) {
                this.defineCommand((String)entry.getKey(), (CommandInfo)entry.getValue());
            }
            this.responseCodec = dialect.getResponseCodec();
            this.log((String)"org.rascalmpl.org.rascalmpl.profiler", new HttpProfilerLogEntry(command.getName(), false));
            return result.createResponse();
        }
        if (this.commandCodec == null || this.responseCodec == null) {
            throw new WebDriverException((String)"org.rascalmpl.org.rascalmpl.No command or response codec has been defined. Unable to proceed");
        }
        HttpRequest httpRequest = this.commandCodec.encode(command);
        if (httpRequest.getHeader((String)"org.rascalmpl.org.rascalmpl.Content-Type") == null) {
            httpRequest.addHeader((String)"org.rascalmpl.org.rascalmpl.Content-Type", (String)"org/rascalmpl/org/rascalmpl/application/json; charset=utf-8");
        }
        try {
            this.log((String)"org.rascalmpl.org.rascalmpl.profiler", new HttpProfilerLogEntry(command.getName(), true));
            HttpResponse httpResponse = this.client.execute(httpRequest);
            this.log((String)"org.rascalmpl.org.rascalmpl.profiler", new HttpProfilerLogEntry(command.getName(), false));
            Response response = this.responseCodec.decode(httpResponse);
            if (response.getSessionId() == null) {
                if (httpResponse.getTargetHost() != null) {
                    response.setSessionId((String)HttpSessionId.getSessionId(httpResponse.getTargetHost()).orElse(null));
                } else {
                    response.setSessionId(command.getSessionId().toString());
                }
            }
            if ("org.rascalmpl.org.rascalmpl.quit".equals((org.rascalmpl.org.rascalmpl.java.lang.Object)command.getName())) {
                this.client.close();
                this.httpClientFactory.cleanupIdleClients();
            }
            return response;
        }
        catch (UnsupportedCommandException e) {
            if (e.getMessage() == null || "org.rascalmpl.org.rascalmpl.".equals((org.rascalmpl.org.rascalmpl.java.lang.Object)e.getMessage())) {
                throw new UnsupportedOperationException((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new org.rascalmpl.org.rascalmpl.java.lang.Object[]{"org.rascalmpl.org.rascalmpl.No information from server. Command name was: \u0001"}, (String)command.getName()), e.getCause());
            }
            throw e;
        }
    }

    private static class DefaultClientFactoryHolder
    extends org.rascalmpl.org.rascalmpl.java.lang.Object {
        static HttpClient.Factory defaultClientFactory = HttpClient.Factory.createDefault();

        private DefaultClientFactoryHolder() {
        }
    }
}

