/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote;

import org.rascalmpl.org.rascalmpl.java.lang.Iterable;
import org.rascalmpl.org.rascalmpl.java.lang.Long;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.ArrayList;
import org.rascalmpl.org.rascalmpl.java.util.Collection;
import org.rascalmpl.org.rascalmpl.java.util.LinkedHashSet;
import org.rascalmpl.org.rascalmpl.java.util.List;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Set;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.Beta;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.UnsupportedCommandException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.WebDriverException;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.logging.LocalLogs;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.logging.LogCombiner;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.logging.LogEntries;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.logging.LogEntry;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.logging.LogLevelMapping;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.logging.Logs;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.ExecuteMethod;

@Beta
public class RemoteLogs
extends org.rascalmpl.org.rascalmpl.java.lang.Object
implements Logs {
    private static final String LEVEL = "org.rascalmpl.org.rascalmpl.level";
    private static final String TIMESTAMP = "org.rascalmpl.org.rascalmpl.timestamp";
    private static final String MESSAGE = "org.rascalmpl.org.rascalmpl.message";
    private static final Logger LOG = Logger.getLogger((String)RemoteLogs.class.getName());
    protected ExecuteMethod executeMethod;
    public static final String TYPE_KEY = "org.rascalmpl.org.rascalmpl.type";
    private final LocalLogs localLogs;

    public RemoteLogs(ExecuteMethod executeMethod, LocalLogs localLogs) {
        this.executeMethod = executeMethod;
        this.localLogs = localLogs;
    }

    @Override
    public LogEntries get(String logType) {
        if ("org.rascalmpl.org.rascalmpl.profiler".equals((org.rascalmpl.org.rascalmpl.java.lang.Object)logType)) {
            LogEntries remoteEntries = new LogEntries((Iterable<LogEntry>)new ArrayList());
            try {
                remoteEntries = this.getRemoteEntries(logType);
            }
            catch (WebDriverException e) {
                LOG.log(Level.WARNING, (String)"org.rascalmpl.org.rascalmpl.Remote profiler logs are not available and have been omitted.", (Throwable)((Object)e));
            }
            return LogCombiner.combine(remoteEntries, this.getLocalEntries(logType));
        }
        if ("org.rascalmpl.org.rascalmpl.client".equals((org.rascalmpl.org.rascalmpl.java.lang.Object)logType)) {
            return this.getLocalEntries(logType);
        }
        return this.getRemoteEntries(logType);
    }

    private LogEntries getRemoteEntries(String logType) {
        org.rascalmpl.org.rascalmpl.java.lang.Object raw = this.executeMethod.execute((String)"org.rascalmpl.org.rascalmpl.getLog", Map.of((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.type", (org.rascalmpl.org.rascalmpl.java.lang.Object)logType));
        if (!(raw instanceof List)) {
            throw new UnsupportedCommandException((String)"org.rascalmpl.org.rascalmpl.malformed response to remote logs command");
        }
        List rawList = (List)raw;
        ArrayList remoteEntries = new ArrayList(rawList.size());
        for (Map obj : rawList) {
            remoteEntries.add((org.rascalmpl.org.rascalmpl.java.lang.Object)new LogEntry(LogLevelMapping.toLevel((String)obj.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.level")), ((Long)obj.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.timestamp")).longValue(), (String)obj.get((org.rascalmpl.org.rascalmpl.java.lang.Object)"org.rascalmpl.org.rascalmpl.message")));
        }
        return new LogEntries((Iterable<LogEntry>)remoteEntries);
    }

    private LogEntries getLocalEntries(String logType) {
        return this.localLogs.get(logType);
    }

    private Set<String> getAvailableLocalLogs() {
        return this.localLogs.getAvailableLogTypes();
    }

    @Override
    public Set<String> getAvailableLogTypes() {
        org.rascalmpl.org.rascalmpl.java.lang.Object raw = this.executeMethod.execute((String)"org.rascalmpl.org.rascalmpl.getAvailableLogTypes", null);
        List rawList = (List)raw;
        LinkedHashSet builder = new LinkedHashSet();
        builder.addAll((Collection)rawList);
        builder.addAll(this.getAvailableLocalLogs());
        return Set.copyOf((Collection)builder);
    }
}

