/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote;

import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.util.Map;
import org.rascalmpl.org.rascalmpl.java.util.Objects;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.logging.LocalLogs;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.logging.NeedsLocalLogs;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.Command;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.CommandExecutor;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.Response;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.SessionId;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.tracing.Span;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.tracing.Tracer;

public class TracedCommandExecutor
extends Object
implements CommandExecutor,
NeedsLocalLogs {
    private final CommandExecutor delegate;
    private final Tracer tracer;

    public TracedCommandExecutor(CommandExecutor delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    @Override
    public Response execute(Command command) throws IOException {
        Span commandSpan = this.tracer.getCurrentContext().createSpan((String)"org.rascalmpl.org.rascalmpl.command");
        try {
            SessionId sessionId = command.getSessionId();
            if (sessionId != null) {
                commandSpan.setAttribute((String)"org.rascalmpl.org.rascalmpl.sessionId", sessionId.toString());
            }
            commandSpan.setAttribute((String)"org.rascalmpl.org.rascalmpl.command", command.getName());
            Map<String, ?> parameters = command.getParameters();
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry parameter : parameters.entrySet()) {
                    commandSpan.setAttribute((String)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.parameter.\u0001"}, (String)((String)parameter.getKey())), Objects.toString((Object)parameter.getValue(), (String)"org.rascalmpl.org.rascalmpl.null"));
                }
            }
            Response response = this.delegate.execute(command);
            if (commandSpan != null) {
                commandSpan.close();
            }
            return response;
        }
        catch (Throwable throwable) {
            if (commandSpan != null) {
                try {
                    commandSpan.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public void setLocalLogs(LocalLogs logs) {
        if (this.delegate instanceof NeedsLocalLogs) {
            ((NeedsLocalLogs)((java.lang.Object)this.delegate)).setLocalLogs(logs);
        }
    }
}

