/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http;

import org.rascalmpl.org.rascalmpl.java.io.IOException;
import org.rascalmpl.org.rascalmpl.java.io.UncheckedIOException;
import org.rascalmpl.org.rascalmpl.java.lang.Object;
import org.rascalmpl.org.rascalmpl.java.lang.RuntimeException;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.lang.invoke.StringConcatFactory;
import org.rascalmpl.org.rascalmpl.java.net.MalformedURLException;
import org.rascalmpl.org.rascalmpl.java.net.Proxy;
import org.rascalmpl.org.rascalmpl.java.net.URI;
import org.rascalmpl.org.rascalmpl.java.net.URISyntaxException;
import org.rascalmpl.org.rascalmpl.java.net.URL;
import org.rascalmpl.org.rascalmpl.java.time.Duration;
import org.rascalmpl.org.rascalmpl.javax.net.ssl.SSLContext;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.Credentials;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.internal.Require;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.AddSeleniumUserAgent;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.Filter;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.RetryRequest;

public class ClientConfig
extends Object {
    private static final Filter RETRY_FILTER = new RetryRequest();
    private static final Filter DEFAULT_FILTER = new AddSeleniumUserAgent();
    private final URI baseUri;
    private final Duration connectionTimeout;
    private final Duration readTimeout;
    private final Filter filters;
    private final Proxy proxy;
    private final Credentials credentials;
    private final SSLContext sslContext;
    private final String version;

    protected ClientConfig(URI baseUri, Duration connectionTimeout, Duration readTimeout, Filter filters, Proxy proxy, Credentials credentials, SSLContext sslContext, String version) {
        this.baseUri = baseUri;
        this.connectionTimeout = Require.nonNegative((String)"org.rascalmpl.org.rascalmpl.Connection timeout", connectionTimeout);
        this.readTimeout = Require.nonNegative((String)"org.rascalmpl.org.rascalmpl.Read timeout", readTimeout);
        this.filters = Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Filters", filters);
        this.proxy = proxy;
        this.credentials = credentials;
        this.sslContext = sslContext;
        this.version = version;
    }

    public static ClientConfig defaultConfig() {
        return new ClientConfig(null, Duration.ofSeconds((long)10L), Duration.ofMinutes((long)3L), DEFAULT_FILTER, null, null, null, null);
    }

    public ClientConfig baseUri(URI baseUri) {
        return new ClientConfig(Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Base URI", baseUri), this.connectionTimeout, this.readTimeout, this.filters, this.proxy, this.credentials, this.sslContext, this.version);
    }

    public ClientConfig baseUrl(URL baseUrl) {
        try {
            return this.baseUri(Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Base URL", baseUrl).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException((Throwable)((java.lang.Object)e));
        }
    }

    public URI baseUri() {
        return this.baseUri;
    }

    public URL baseUrl() {
        try {
            return this.baseUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException((IOException)((java.lang.Object)e));
        }
    }

    public ClientConfig connectionTimeout(Duration timeout) {
        return new ClientConfig(this.baseUri, Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Connection timeout", timeout), this.readTimeout, this.filters, this.proxy, this.credentials, this.sslContext, this.version);
    }

    public Duration connectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientConfig readTimeout(Duration timeout) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Read timeout", timeout), this.filters, this.proxy, this.credentials, this.sslContext, this.version);
    }

    public Duration readTimeout() {
        return this.readTimeout;
    }

    public ClientConfig withFilter(Filter filter) {
        Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Filter", filter);
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, filter.andThen(DEFAULT_FILTER), this.proxy, this.credentials, this.sslContext, this.version);
    }

    public ClientConfig withRetries() {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.filters.andThen(RETRY_FILTER), this.proxy, this.credentials, this.sslContext, this.version);
    }

    public Filter filter() {
        return this.filters;
    }

    public ClientConfig proxy(Proxy proxy) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.filters, Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Proxy", proxy), this.credentials, this.sslContext, this.version);
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public ClientConfig authenticateAs(Credentials credentials) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.filters, this.proxy, Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Credentials", credentials), this.sslContext, this.version);
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public ClientConfig sslContext(SSLContext sslContext) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.filters, this.proxy, this.credentials, Require.nonNull((String)"org.rascalmpl.org.rascalmpl.SSL Context", sslContext), this.version);
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public ClientConfig version(String version) {
        return new ClientConfig(this.baseUri, this.connectionTimeout, this.readTimeout, this.filters, this.proxy, this.credentials, this.sslContext, Require.nonNull((String)"org.rascalmpl.org.rascalmpl.Version", version));
    }

    public String version() {
        return this.version;
    }

    public String toString() {
        return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"org.rascalmpl.org.rascalmpl.ClientConfig{baseUri=\u0001, connectionTimeout=\u0001, readTimeout=\u0001, filters=\u0001, proxy=\u0001, credentials=\u0001, sslcontext=\u0001, version=\u0001}"}, (String)String.valueOf((Object)this.baseUri), (String)String.valueOf((Object)this.connectionTimeout), (String)String.valueOf((Object)this.readTimeout), (String)String.valueOf((Object)this.filters), (String)String.valueOf((Object)this.proxy), (String)String.valueOf((Object)this.credentials), (String)String.valueOf((Object)this.sslContext), (String)this.version);
    }
}

