/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http;

import org.rascalmpl.org.rascalmpl.java.io.Closeable;
import org.rascalmpl.org.rascalmpl.java.lang.CharSequence;
import org.rascalmpl.org.rascalmpl.java.lang.String;
import org.rascalmpl.org.rascalmpl.java.lang.Throwable;
import org.rascalmpl.org.rascalmpl.java.util.function.Consumer;
import org.rascalmpl.org.rascalmpl.java.util.logging.Level;
import org.rascalmpl.org.rascalmpl.java.util.logging.Logger;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.BinaryMessage;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.CloseMessage;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.Message;
import org.rascalmpl.org.rascalmpl.org.openqa.selenium.remote.http.TextMessage;

public interface WebSocket
extends Closeable {
    public static final Logger LOG = Logger.getLogger((String)WebSocket.class.getName());

    public WebSocket send(Message var1);

    default public WebSocket sendText(CharSequence data) {
        return this.send(new TextMessage(data));
    }

    default public WebSocket sendBinary(byte[] data) {
        return this.send(new BinaryMessage(data));
    }

    public void close();

    public static interface Listener
    extends Consumer<Message> {
        default public void accept(Message message) {
            if (message instanceof BinaryMessage) {
                this.onBinary(((BinaryMessage)message).data());
            } else if (message instanceof CloseMessage) {
                this.onClose(((CloseMessage)message).code(), ((CloseMessage)message).reason());
            } else if (message instanceof TextMessage) {
                this.onText((CharSequence)((TextMessage)message).text());
            }
        }

        default public void onBinary(byte[] data) {
        }

        default public void onClose(int code, String reason) {
        }

        default public void onText(CharSequence data) {
        }

        default public void onError(Throwable cause) {
            String message = cause.getMessage();
            if (message == null && cause.getCause() != null) {
                message = cause.getCause().getMessage();
            }
            LOG.log(Level.WARNING, message, cause);
        }
    }
}

